package com.elitesland.tw.tw5.server.prd.task.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPackagePayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * 任务包管理
 *
 * @author xxb
 * @date 2023-11-17
 */
@Api(tags = "任务包管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/taskPackage")
@Slf4j
public class TaskPackageController {

    private final TaskPackageService taskPackageService;

    /**
     * 初始化任务包
     *
     * @param reasonType
     * @param reasonId
     * @param receiverResId
     * @return
     */
    @GetMapping("/initTaskPackage")
    @UdcNameClass
    @ApiOperation("初始化任务包")
    public TwOutputUtil initTaskPackage(String reasonType, Long reasonId, Long receiverResId) {
        return TwOutputUtil.ok(taskPackageService.initTaskPackage(reasonType, reasonId, receiverResId));
    }

    /**
     * 基于项目成员新增任务包
     *
     * @param taskPackagePayload
     * @return
     */
    @PostMapping("/addTaskPackageByMember")
    @ApiOperation("基于项目成员新增任务包")
    public TwOutputUtil<TaskPackageVO> addTaskPackageByMember(@RequestBody TaskPackagePayload taskPackagePayload) {
        return TwOutputUtil.ok(taskPackageService.addTaskPackageByMember(taskPackagePayload));
    }

    /**
     * 基于项目成员新增任务包
     *
     * @param taskPackagePayload
     * @return
     */
    @PostMapping("/addTaskPackage")
    @ApiOperation("新增任务包")
    public TwOutputUtil<TaskPackageVO> addTaskPackage(@RequestBody TaskPackagePayload taskPackagePayload) {
        return TwOutputUtil.ok(taskPackageService.addTaskPackage(taskPackagePayload));
    }

    /**
     * 查看任务包详情
     *
     * @param key
     * @return
     */
    @GetMapping("/getTaskPackageDetail")
    @UdcNameClass
    @ApiOperation("查看任务包详情")
    public TwOutputUtil<TaskPackageVO> getTaskPackageDetail(Long key, Boolean needTasks) {
        return TwOutputUtil.ok(taskPackageService.queryByKey(key, needTasks));
    }

    /**
     * 任务包列表
     *
     * @return
     */
    @GetMapping("/taskPackageList")
    @UdcNameClass
    @ApiOperation("任务包列表")
    public TwOutputUtil<List<TaskPackageVO>> taskPackageList(TaskPackageQuery taskPackageQuery) {
        return TwOutputUtil.ok(taskPackageService.taskPackageList(taskPackageQuery));
    }

    /**
     * 任务包查询-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("任务包查询-分页")
    public TwOutputUtil<PagingVO<TaskPackageVO>> paging(TaskPackageQuery query) {
        return TwOutputUtil.ok(taskPackageService.queryPaging(query));
    }

    /**
     * 任务包数量
     *
     * @return
     */
    @GetMapping("/taskPackageCount")
    @ApiOperation("任务包数量")
    public TwOutputUtil taskPackageCount(TaskPackageQuery taskPackageQuery) {
        return TwOutputUtil.ok(taskPackageService.taskPackageCount(taskPackageQuery));
    }

    /**
     * 我的任务包列表
     *
     * @return
     */
    @GetMapping("/taskMyPackageList")
    @ApiOperation("我的任务包列表")
    public TwOutputUtil<List<TaskPackageVO>> taskMyPackageList(TaskPackageQuery taskPackageQuery) {
        return TwOutputUtil.ok(taskPackageService.taskMyPackageList(taskPackageQuery));
    }

    @GetMapping("/taskMyPackageListDib")
    @ApiOperation("我的任务包列表-迪博")
    public TwOutputUtil<List<TaskPackageVO>> taskMyPackageListDib(TaskPackageQuery taskPackageQuery) {
        return TwOutputUtil.ok(taskPackageService.taskMyPackageListDib(taskPackageQuery));
    }

    /**
     * 任务包-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("任务包-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        taskPackageService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}
