package com.elitesland.tw.tw5.server.prd.ts.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 工时审批资源管理
 *
 * @author carl
 * @date 2024-05-04
 */
@Entity
@Table(name = "ts_approval_res", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "ts_approval_res", comment = "工时审批资源管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TsApprovalResDO extends BaseModel implements Serializable {
    /**
     * 工时id
     */
    @Comment("工时id")
    @Column()
    private Long timesheetId;

    /**
     * 配置类型
     */
    @ApiModelProperty("配置类型")
    private String configType;

    /**
     * 配置id
     */
    @Comment("配置id")
    @Column()
    private Long configId;
    /**
     * 审批资源id
     */
    @Comment("审批资源id")
    @Column()
    private Long approvalResId;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String approvalStatus;
    /**
     * 审批资源描述(项目经理，交付负责人等)
     */
    @Comment("审批资源描述(项目经理，交付负责人等)")
    @Column()
    private String approvalSource;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvalTime;
    /**
     * 首次审批时间（前端不用）
     */
    @Comment("首次审批时间（前端不用）")
    @Column()
    private LocalDateTime fristApprovalTime;
    /**
     * 排序
     */
    @Comment("排序")
    @Column()
    private Integer sortIndex;
    /**
     * 最后审批人
     */
    @Comment("最后审批人")
    @Column()
    private Integer lastFlag;

    public void copy(TsApprovalResDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
