package com.elitesland.tw.tw5.server.yeedoc.config;

import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * yeedoc属性
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
@ConfigurationProperties("yeedoc")
// 支持动态刷新
@NacosConfigurationProperties(dataId = "yeedoc", autoRefreshed = true)
public class YeedocProperties {

//    private String yeeDocLinkUrl = "https://yeedoc.elitesland.com";

    /**
     * 调用易稻壳传的系统来源
     */
    private String source = "6";

    /**
     * 易稻壳api地址
     * 测试环境：http://192.168.0.164:8089
     * 生产环境：https://yeedoc.elitesland.com
     */
    private String yeeDocLinkUrl = "http://192.168.0.164:8089";

    /**
     * 易稻壳赋权 易稻壳权限id集合
     *
     *             // 易道壳赋权
     * //        DA3AB474-D24C-4BE1-9386-88512EA0EF1D        管控        管控        0.00
     * //        BED09C0C-8E07-4847-9829-58342C1509F2        预览        预览        0.00
     * //        EDC7A542-E767-4522-BDA6-4CCD5786127E        新建文件夹        新建文件夹        0.00
     * //        6D29280D-A712-421F-BE19-5308E0FD1D77        新建文档        新建文档        0.00
     * //        B7AB3B26-3CC3-420A-B149-307CCD6FF8E4        编辑        编辑        11.00
     * //        389DAFDD-7606-43FB-9A82-B52F0EC96C7B        上传        上传        0.00
     * //        D5094C42-6E70-4940-BB34-184649CDA78F        脱密下载        脱密下载        9.00
     * //        33C2511A-AC87-4818-9FF8-14B0B611F45A        加密下载        加密下载        0.00
     * //        EB28CF8B-E26E-45F2-90E2-CEDD6EF0E0F6        作废        作废        7.00
     * //        0881B142-80B3-4986-A25B-17D98924F7DB        移动复制        移动复制        10.00
     * //        336B72CD-31DB-4F01-B189-CCFD97B51E56        分享        内部分享        8.00
     */
    private String[] permission = {"DA3AB474-D24C-4BE1-9386-88512EA0EF1D", "BED09C0C-8E07-4847-9829-58342C1509F2", "EDC7A542-E767-4522-BDA6-4CCD5786127E",
        "6D29280D-A712-421F-BE19-5308E0FD1D77", "B7AB3B26-3CC3-420A-B149-307CCD6FF8E4", "389DAFDD-7606-43FB-9A82-B52F0EC96C7B", "D5094C42-6E70-4940-BB34-184649CDA78F",
        "33C2511A-AC87-4818-9FF8-14B0B611F45A", "EB28CF8B-E26E-45F2-90E2-CEDD6EF0E0F6", "0881B142-80B3-4986-A25B-17D98924F7DB", "336B72CD-31DB-4F01-B189-CCFD97B51E56"};
    /**
     * 易稻壳识别标识
     * 测试环境 testshow
     * 生产环境 tw5
     */
    private String externalSource = "testshow";

    private String saleConLibraryId;

    /**
     * 单点登录调用易稻壳的加密key
     */
    private String sercretKey ;

    /**
     * 单点登录跳转易稻壳的url
     */
    private String yeedocSsoUrl ;
    /**
     * 合同开票文件库
     */
    private String invBatchLibraryId ;
    /**
     * 合同开票附件文件夹
     */
    private String invBatchFolderId ;

    /**
     * 商机文档导入 相关配置
     */
    private CrmOpportunityFolder oppoFolder = new CrmOpportunityFolder();

    public YeedocProperties() {
    }
}
