/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.service;

import com.elitesland.tw.tw5.server.common.dao.TransferUtilDAO;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TransferUtilServiceImpl {
    private final CacheUtil cacheUtil;
    private final TransferUtilDAO dao;

    public Map<String, Object> beanToMap(Object obj) {
        Map<String, Object> map = BeanUtil.beanToMap(obj);
        ArrayList<Long> userIds = new ArrayList<Long>();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        ArrayList<Long> bookIds = new ArrayList<Long>();
        ArrayList<Long> oppoIds = new ArrayList<Long>();
        for (Field field : obj.getClass().getDeclaredFields()) {
            Object o = null;
            try {
                field.setAccessible(true);
                o = field.get(obj);
                if (o != null && field.get(obj) instanceof Long) {
                    if (field.getName().contains("userId") || field.getName().contains("UserId")) {
                        userIds.add((Long)field.get(obj));
                    }
                    if (field.getName().contains("orgId") || field.getName().contains("OrgId")) {
                        orgIds.add((Long)field.get(obj));
                    }
                    if (field.getName().contains("bookId") || field.getName().contains("BookId")) {
                        bookIds.add((Long)field.get(obj));
                    }
                    if (field.getName().contains("oppoId") || field.getName().contains("OppoId")) {
                        oppoIds.add((Long)field.get(obj));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            map.put(field.getName(), o);
        }
        List<Object> tw4UserMaps = new ArrayList();
        if (userIds.size() > 0) {
            tw4UserMaps = this.dao.queryEmployeeTw4Maps(userIds);
        }
        List<Object> tw4OrgMaps = new ArrayList();
        if (orgIds.size() > 0) {
            tw4OrgMaps = this.dao.queryOrgTw4Maps(orgIds);
        }
        List<Object> tw4BookMaps = new ArrayList();
        if (bookIds.size() > 0) {
            tw4BookMaps = this.dao.queryBookTw4Maps(bookIds);
        }
        List<Object> tw4OppoMaps = new ArrayList();
        if (oppoIds.size() > 0) {
            tw4OppoMaps = this.dao.queryOppoTw4Maps(oppoIds);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Optional<Map> userId;
            if (entry.getValue() == null || !(entry.getValue() instanceof Long)) continue;
            if ((entry.getKey().contains("userId") || entry.getKey().contains("UserId")) && !entry.getKey().contains("V4") && (userId = tw4UserMaps.stream().filter(tw4UserMap -> Long.valueOf("" + tw4UserMap.get("userId")).longValue() == ((Long)entry.getValue()).longValue()).findFirst()).isPresent()) {
                map.put(entry.getKey(), userId.get().get("userIdV4"));
            }
            if ((entry.getKey().contains("orgId") || entry.getKey().contains("OrgId")) && !entry.getKey().contains("V4")) {
                Map orgMap = tw4OrgMaps.stream().filter(tw4OrgMap -> Long.valueOf("" + tw4OrgMap.get("id")).longValue() == ((Long)entry.getValue()).longValue()).findFirst().get();
                map.put(entry.getKey(), orgMap.get("orgIdV4"));
            }
            if ((entry.getKey().contains("bookId") || entry.getKey().contains("BookId")) && !entry.getKey().contains("V4") && !CollectionUtils.isEmpty(tw4BookMaps)) {
                Map bookMap = tw4BookMaps.stream().filter(tw4BookMap -> Long.valueOf("" + tw4BookMap.get("id")).longValue() == ((Long)entry.getValue()).longValue()).findFirst().get();
                map.put(entry.getKey(), bookMap.get("bookIdV4"));
            }
            if (!entry.getKey().contains("oppoId") && !entry.getKey().contains("OppoId") || entry.getKey().contains("V4")) continue;
            Map oppoMap = tw4OppoMaps.stream().filter(tw4OppoMap -> Long.valueOf("" + tw4OppoMap.get("id")).longValue() == ((Long)entry.getValue()).longValue()).findFirst().get();
            map.put(entry.getKey(), oppoMap.get("oppoIdV4"));
        }
        return map;
    }

    public List<Long> queryEmployeeTw4Ids(List<Long> userIds) {
        return this.dao.queryEmployeeTw4Ids(userIds);
    }

    public TransferUtilServiceImpl(CacheUtil cacheUtil, TransferUtilDAO dao) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
    }
}

