/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetChangePayload;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetChangeVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetUsageDetailsVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9884\u7b97\u57fa\u672c\u4fe1\u606f--2.0"})
@RestController
@RequestMapping(value={"/api/budget"})
public class BudgetController {
    private static final Logger log = LoggerFactory.getLogger(BudgetController.class);
    private final BudgetService budgetService;
    private final BudgetCommonService budgetCommonService;

    @GetMapping(value={"/querySimpleBySource"})
    @UdcNameClass
    @ApiOperation(value="\u901a\u8fc7 \u8d44\u6e90 \u67e5\u8be2\u9884\u7b97--\u7b80\u5355\u9884\u7b97\u67e5\u8be2")
    public TwOutputUtil<BudgetVO> querySimpleBySource(Long sourceId, String sourceType) {
        return TwOutputUtil.ok(this.budgetCommonService.querySimpleBySource(sourceId, sourceType));
    }

    @GetMapping(value={"/queryBySource"})
    @UdcNameClass
    @ApiOperation(value="\u901a\u8fc7 \u8d44\u6e90 \u67e5\u8be2\u9884\u7b97--\u9884\u7b97\u8be6\u60c5")
    public TwOutputUtil<BudgetVO> queryBySource(Long sourceId, String sourceType) {
        return TwOutputUtil.ok(this.budgetService.queryBySource(sourceId, sourceType));
    }

    @PostMapping(value={"/saveFirstBudget"})
    @ApiOperation(value="\u9996\u6b21\u9884\u7b97-\u65b0\u589e\u6216\u4fee\u6539")
    public TwOutputUtil saveFirstBudget(@RequestBody BudgetPayload payload) {
        return TwOutputUtil.ok(this.budgetService.saveFirstBudget(payload));
    }

    @PostMapping(value={"/saveOPPOAndBUTypeBudget"})
    @ApiOperation(value="BU\u9884\u7b97\u3001\u5546\u673a\u9884\u7b97 -\u65b0\u589e\u6216\u4fee\u6539")
    @GlobalTransactional
    public TwOutputUtil saveOPPOAndBUTypeBudget(@RequestBody BudgetPayload payload) {
        this.budgetService.saveOPPOAndBUTypeBudget(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryBudgetByKey"})
    @UdcNameClass
    @ApiOperation(value="\u9884\u7b97\u4fe1\u606f-\u9884\u7b97\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<BudgetVO> queryBudgetByKey(Long key) {
        return TwOutputUtil.ok(this.budgetService.queryBudgetByKey(key));
    }

    @PostMapping(value={"/saveBudgetChange"})
    @ApiOperation(value="\u9884\u7b97\u53d8\u66f4-\u65b0\u589e\u6216\u4fee\u6539")
    @GlobalTransactional
    public TwOutputUtil saveBudgetChange(@RequestBody BudgetChangePayload budgetChangePayload) {
        this.budgetService.saveBudgetChange(budgetChangePayload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryBudgetChangeByKey"})
    @UdcNameClass
    @ApiOperation(value="\u9884\u7b97\u53d8\u66f4\u4fe1\u606f-\u53d8\u66f4\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<BudgetChangeVO> queryBudgetChangeByKey(Long key) {
        return TwOutputUtil.ok(this.budgetService.queryBudgetChangeByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u9884\u7b97\u57fa\u672c\u4fe1\u606f-\u5206\u9875")
    public TwOutputUtil<PagingVO<BudgetVO>> paging(BudgetQuery query) {
        return TwOutputUtil.ok(this.budgetService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u9884\u7b97\u57fa\u672c\u4fe1\u606f-\u5217\u8868")
    public TwOutputUtil<List<PmsProjectVO>> queryBudgetList(BudgetQuery query) {
        return TwOutputUtil.ok(this.budgetService.queryList(query));
    }

    @GetMapping(value={"/queryBySubjectTemplateId"})
    @UdcNameClass
    @ApiOperation(value="\u6839\u636e\u79d1\u76ee\u6a21\u677fid\u67e5\u627e\u9884\u7b97\u79d1\u76ee")
    public TwOutputUtil<List<BudgetUsageDetailsVO>> queryBySubjectTemplateId(String sourceType, Long subjectTemplateId) {
        return TwOutputUtil.ok(this.budgetCommonService.queryBySubjectTemplateId(sourceType, subjectTemplateId));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u9884\u7b97\u57fa\u672c\u4fe1\u606f-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.budgetService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryBudgetForAppropriation"})
    @UdcNameClass
    @ApiOperation(value="\u9884\u7b97\u4fe1\u606f-\u9884\u7b97\u4e3b\u952e\u67e5\u8be2\uff08\u4e3a\u4e86\u62e8\u4ed8\uff09")
    public TwOutputUtil<BudgetVO> queryBudgetForAppropriation(Long key) {
        return TwOutputUtil.ok(this.budgetCommonService.queryBudgetForAppropriation(key));
    }

    @GetMapping(value={"/queryProjectNoBudget"})
    @ApiOperation(value="\u6ca1\u6709\u5efa\u7acb\u8fc7\u9884\u7b97\u7684\u9879\u76ee\u5217\u8868")
    public TwOutputUtil<List<PmsProjectVO>> queryProjectNoBudget() {
        return TwOutputUtil.ok(this.budgetService.queryProjectNoBudget());
    }

    @GetMapping(value={"/queryBudgetUsageDetails"})
    @ApiOperation(value="\u5f53\u91cf\u3001\u8d39\u7528 \u4f7f\u7528\u60c5\u51b5")
    public TwOutputUtil<List<BudgetUsageDetailsVO>> queryBudgetUsageDetails(Long sourceId, String sourceType) {
        return TwOutputUtil.ok(this.budgetCommonService.queryBudgetUsageDetails(sourceId, sourceType));
    }

    @GetMapping(value={"/synchronizationTemp"})
    @ApiOperation(value="\u540c\u6b65\u79d1\u76ee\u6a21\u677f")
    public TwOutputUtil synchronizationTemp(Long[] keys, Long tmplId) {
        this.budgetService.synchronizationTemp(Arrays.asList(keys), tmplId);
        return TwOutputUtil.ok();
    }

    public BudgetController(BudgetService budgetService, BudgetCommonService budgetCommonService) {
        this.budgetService = budgetService;
        this.budgetCommonService = budgetCommonService;
    }
}

