/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
@PermissionDomain(domain=PermissionDomainEnum.BUSINESS_OPPORTUNITY)
public class CrmOpportunityController {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityController.class);
    private final CrmOpportunityService service;
    private final BeanSearcher beanSearcher;

    @PostMapping(value={"/oppo/insert"})
    public TwOutputUtil insert(CrmOpportunityPayload payload) {
        CrmOpportunityVO vo = this.service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @PutMapping(value={"/oppo/update"})
    public TwOutputUtil update(CrmOpportunityPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setId(this.service.getIdByV4(payload.getOppoIdV4()));
        }
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/oppo/updateFromV4"})
    public TwOutputUtil updateFromV4(CrmOpportunityPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setId(this.service.getIdByV4(payload.getOppoIdV4()));
        }
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/oppo/toggleCheckStatus"})
    public TwOutputUtil toggleCheckStatus(@RequestBody List<Long> ids) {
        this.service.toggleCheckStatus(ids);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/pagingPro"})
    @UdcNameClass
    public TwOutputUtil pagingPro(CrmOpportunityQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    @GetMapping(value={"/oppo/queryByKey/{id}"})
    @UdcNameClass
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.BUSINESS_DETAIL, type=FunctionTypeEnum.BUTTON)}, fieldPermission=true)
    public TwOutputUtil<CrmOpportunityVO> queryByKey(@PathVariable Long id) {
        CrmOpportunityVO vo = this.service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    @GetMapping(value={"/oppo/changeStatus/{id}"})
    public TwOutputUtil changeStatus(@PathVariable Long id, Long oppoIdV4) {
        if (oppoIdV4 != null) {
            id = this.service.getIdByV4(oppoIdV4);
        }
        this.service.changeStatus(id);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/closeOpportunity"})
    public TwOutputUtil closeOpportunity(Long key, String closeReason, String loseReson, String clsoeRemark, Long oppoIdV4) {
        if (oppoIdV4 != null) {
            key = this.service.getIdByV4(oppoIdV4);
        }
        this.service.closeOpportunity(key, closeReason, loseReson, clsoeRemark, Boolean.valueOf(true));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/addMember"})
    public TwOutputUtil addMember(Long oppoId, Long[] userIds) {
        List memberVOS = this.service.addMember(oppoId, Arrays.asList(userIds));
        return TwOutputUtil.ok(memberVOS);
    }

    @DeleteMapping(value={"/oppo/deleteMember"})
    public TwOutputUtil deleteMember(Long oppoId, Long[] keys) {
        this.service.deleteMember(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/oppo/addFollow"})
    public TwOutputUtil addFollow(CrmFollowPayload payload) {
        this.service.addFollow(payload);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/oppo/updateFollow"})
    public TwOutputUtil updateFollow(CrmFollowPayload payload) {
        this.service.updateFollow(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/queryListFollow"})
    public TwOutputUtil queryListFollow(Long objectId) {
        return TwOutputUtil.ok(this.service.queryListFollow(objectId));
    }

    @GetMapping(value={"/oppo/queryLogList"})
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok(this.service.queryLogList(query));
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/oppo/batchExport"})
    public void batchExport(HttpServletResponse response, CrmOpportunityQuery query) throws IOException {
        this.service.downloadBatch(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @PostMapping(value={"/oppo/permission/batchExport"})
    public void permissionBatchExport(HttpServletResponse response, @RequestBody CrmOpportunityQuery query) throws IOException {
        this.service.permissionBatchExport(response, query);
    }

    @GetMapping(value={"/oppo/bindCustomer/{id}"})
    public TwOutputUtil bindCustomer(@PathVariable Long id) {
        Map result = new HashMap();
        try {
            result = this.service.bindCustomer(id);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.service.deleteSoft(id);
            return TwOutputUtil.error("", "\u7ed1\u5b9a\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", "");
        }
        return TwOutputUtil.ok(result);
    }

    @GetMapping(value={"/oppo/bindCustomers"})
    public TwOutputUtil bindCustomers() {
        return TwOutputUtil.ok(this.service.bindCustomers());
    }

    @GetMapping(value={"/oppo/list"})
    @UdcNameClass
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryListDynamic(CrmOpportunityQuery query) {
        return TwOutputUtil.ok(this.service.queryListDynamic(query));
    }

    @PostMapping(value={"/oppo/paging"})
    @UdcNameClass
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.BUSINESS_PAGE, type=FunctionTypeEnum.TAB)}, fieldPermission=true, permissionType=PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<CrmOpportunityVO>> permissionPaging(@RequestBody CrmOpportunityQuery query) {
        return TwOutputUtil.ok(this.service.permissionPaging(query));
    }

    @PostMapping(value={"/oppo/pagingOld"})
    @UdcNameClass
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<PagingVO<CrmOpportunityVO>> pagingOld(@RequestBody CrmOpportunityQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    @PostMapping(value={"/oppo/test"})
    @UdcNameClass
    public TwOutputUtil<PagingVO<CrmOpportunityVO>> permissionTest(@RequestBody CrmOpportunityQuery query) {
        MapBuilder mapBuilder = ((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)MapUtils.builder().group("A").field("id", new Object[]{1})).op((FieldOp)FieldOps.Equal)).group("B").field("projectId2", new Object[]{2})).op((FieldOp)FieldOps.Equal)).groupExpr("A|B");
        this.beanSearcher.search(CrmOpportunityVO.class, mapBuilder.build());
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/selectOpportunityListByUserBu"})
    @UdcNameClass
    public TwOutputUtil<List<CrmOpportunityVO>> selectOpportunityListByUserBu() {
        return TwOutputUtil.ok(this.service.selectOpportunityListByUserBu());
    }

    @GetMapping(value={"/oppo/caculateProbability/{key}"})
    @ApiOperation(value="\u8ba1\u7b97\u5546\u673a\u6210\u5355\u6982\u7387")
    public TwOutputUtil caculateProbability(@PathVariable Long key) {
        return TwOutputUtil.ok(this.service.caculateProbability(key));
    }

    public CrmOpportunityController(CrmOpportunityService service, BeanSearcher beanSearcher) {
        this.service = service;
        this.beanSearcher = beanSearcher;
    }
}

