/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreAdminPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshoreMembersPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOffshoreService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOffshoreVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOffshoreConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOffshoreDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CrmOffshoreServiceImpl
implements CrmOffshoreService {
    private static final Logger log = LoggerFactory.getLogger(CrmOffshoreServiceImpl.class);
    private final CrmOffshoreDAO dao;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final ExcelUtil excelUtil;

    public CrmOffshoreVO saveOne(CrmOffshorePayload payload) {
        CrmOffshoreDO ado = CrmOffshoreConvert.INSTANCE.toDo(payload);
        try {
            if (payload.getId() != null) {
                int num = this.dao.countLeads(ado.getId());
                ado.setLeadsNum(num);
            }
            ado = this.dao.save(ado);
        }
        catch (Exception e) {
            throw TwException.error("", "\u8fd1\u6d77\u540d\u79f0\u4e0d\u80fd\u91cd\u590d,\u5df2\u5b58\u5728\u540d\u4e3a\"" + payload.getOffshoreName() + "\"\u7684\u8fd1\u6d77\uff01");
        }
        return CrmOffshoreConvert.INSTANCE.toVo(ado);
    }

    public void dynamicUpdate(CrmOffshorePayload payload) {
        this.dao.updateByKeyDynamic(payload);
    }

    @Transactional(readOnly=true)
    public List<CrmOffshoreListVO> queryList(CrmOffshoreQuery query) {
        query.setOffshoreNameNotEqual("\u65e0\u8fd1\u6d77");
        Specification<CrmOffshoreDO> spec = this.dao.getSpec(query);
        List<CrmOffshoreDO> all = this.dao.findAll(spec);
        return all.stream().map(e -> CrmOffshoreConvert.INSTANCE.toListVo((CrmOffshoreDO)((Object)e))).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public PagingVO paging(CrmOffshoreQuery query) {
        Specification<CrmOffshoreDO> spec = this.dao.getSpec(query);
        Page<CrmOffshoreDO> all = this.dao.findAll(spec, (Pageable)query.getPageRequest());
        List content = all.getContent();
        List<CrmOffshoreListVO> collect = content.stream().map(e -> CrmOffshoreConvert.INSTANCE.toListVo((CrmOffshoreDO)((Object)e))).collect(Collectors.toList());
        this.transferList(collect);
        all.getTotalPages();
        PagingVO pagingVO = new PagingVO(all.getTotalElements(), collect);
        return pagingVO;
    }

    @Transactional
    public CrmOffshoreVO queryDetail(Long id) {
        CrmOffshoreDO detail = this.dao.queryById(id);
        return CrmOffshoreConvert.INSTANCE.toVo(detail);
    }

    private void transferList(List<CrmOffshoreListVO> list) {
        for (CrmOffshoreListVO vo : list) {
            List offshoreAdmins = vo.getOffshoreAdmins();
            List offshoreMembers = vo.getOffshoreMembers();
            offshoreMembers.stream().map(e -> {
                e.setUserName(this.cacheUtil.getUserName(e.getUserId()));
                return e;
            }).collect(Collectors.toList());
            offshoreAdmins.stream().map(e -> {
                e.setUserName(this.cacheUtil.getUserName(e.getUserId()));
                return e;
            }).collect(Collectors.toList());
        }
    }

    @Transactional
    public void importOffshores(MultipartFile file) {
        int dataStartRow;
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error(e2.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u8fd1\u6d77\u6570\u636e");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        for (int i = dataStartRow = 1; i <= sheet.getLastRowNum(); ++i) {
            List<Long> collect;
            Row row = sheet.getRow(i);
            CrmOffshorePayload offshorePayload = new CrmOffshorePayload();
            List<Object> membersPayloads = new ArrayList();
            List<Object> adminPayloads = new ArrayList();
            offshorePayload.setOffshoreName(ExcelUtil.getCellFormatValue(row.getCell(1)));
            String offshoreMembersStr = ExcelUtil.getCellFormatValue(row.getCell(2));
            String offshoreAdminsStr = ExcelUtil.getCellFormatValue(row.getCell(3));
            if (StringUtils.hasText((String)offshoreMembersStr)) {
                String[] members = offshoreMembersStr.split(",");
                collect = Arrays.stream(members).map(e -> Long.parseLong(e)).collect(Collectors.toList());
                List<Long> memberUserIds = this.employeeDAO.queryUserIdByEmployeeNo(collect);
                membersPayloads = memberUserIds.stream().map(e -> {
                    CrmOffshoreMembersPayload membersPayload = new CrmOffshoreMembersPayload();
                    membersPayload.setUserId(e);
                    return membersPayload;
                }).collect(Collectors.toList());
                offshorePayload.setOffshoreMembers(membersPayloads);
            }
            if (StringUtils.hasText((String)offshoreAdminsStr)) {
                String[] admins = offshoreAdminsStr.split(",");
                collect = Arrays.stream(admins).map(e -> Long.parseLong(e)).collect(Collectors.toList());
                List<Long> adminUserIds = this.employeeDAO.queryUserIdByEmployeeNo(collect);
                adminPayloads = adminUserIds.stream().map(e -> {
                    CrmOffshoreAdminPayload adminPayload = new CrmOffshoreAdminPayload();
                    adminPayload.setUserId(e);
                    return adminPayload;
                }).collect(Collectors.toList());
                offshorePayload.setOffshoreAdmins(adminPayloads);
            }
            this.saveOne(offshorePayload);
        }
    }

    public void downloadOffshores(HttpServletResponse response, CrmOffshoreQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/offshoreBatch.xlsx");
        PagingVO paging = this.paging(query);
        List records = paging.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u8fd1\u6d77\u6570\u636e");
            if (!CollectionUtils.isEmpty((Collection)records) && batchProjectSheet != null) {
                int nextRow = 2;
                for (CrmOffshoreListVO dataPayload : records) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, nextRow);
                    this.excelUtil.setCellValue((Row)row, 1, dataPayload.getOffshoreName());
                    this.excelUtil.setCellValue((Row)row, 3, dataPayload.getLeadsNum());
                    List offshoreMembers = dataPayload.getOffshoreMembers();
                    List offshoreAdmins = dataPayload.getOffshoreAdmins();
                    List collect = offshoreMembers.stream().map(e -> {
                        Long userId = e.getUserId();
                        return this.cacheUtil.getUserName(userId);
                    }).collect(Collectors.toList());
                    String members = String.join((CharSequence)",", collect);
                    this.excelUtil.setCellValue((Row)row, 2, members);
                    List adminList = offshoreAdmins.stream().map(e -> {
                        Long userId = e.getUserId();
                        return this.cacheUtil.getUserName(userId);
                    }).collect(Collectors.toList());
                    String admins = String.join((CharSequence)",", collect);
                    this.excelUtil.setCellValue((Row)row, 3, admins);
                    ++nextRow;
                }
            }
            String fileName = "\u8fd1\u6d77\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public CrmOffshoreServiceImpl(CrmOffshoreDAO dao, CacheUtil cacheUtil, PrdOrgEmployeeDAO employeeDAO, ExcelUtil excelUtil) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
        this.employeeDAO = employeeDAO;
        this.excelUtil = excelUtil;
    }
}

