/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityMilestonePlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityMilestonePlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityMilestonePlanService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMilestonePlanVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityMilestonePlanConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityMilestonePlanDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityMilestonePlanDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityMilestonePlanRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class CrmOpportunityMilestonePlanServiceImpl
extends BaseServiceImpl
implements CrmOpportunityMilestonePlanService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityMilestonePlanServiceImpl.class);
    private final CrmOpportunityMilestonePlanRepo crmOpportunityMilestonePlanRepo;
    private final CrmOpportunityMilestonePlanDAO crmOpportunityMilestonePlanDAO;
    private final CrmOpportunityDAO crmOpportunityDAO;
    private final PrdMessageConfigService messageConfigService;
    private final CacheUtil cacheUtil;
    private final UdcUtil udcUtil;

    public PagingVO<CrmOpportunityMilestonePlanVO> queryPaging(CrmOpportunityMilestonePlanQuery query) {
        return this.crmOpportunityMilestonePlanDAO.queryPaging(query);
    }

    public List<CrmOpportunityMilestonePlanVO> queryListDynamic(CrmOpportunityMilestonePlanQuery query) {
        return this.crmOpportunityMilestonePlanDAO.queryListDynamic(query);
    }

    public CrmOpportunityMilestonePlanVO queryByKey(Long key) {
        CrmOpportunityMilestonePlanDO entity = this.crmOpportunityMilestonePlanRepo.findById(key).orElseGet(CrmOpportunityMilestonePlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmOpportunityMilestonePlanVO vo = CrmOpportunityMilestonePlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmOpportunityMilestonePlanVO insert(CrmOpportunityMilestonePlanPayload payload) {
        CrmOpportunityMilestonePlanDO entityDo = CrmOpportunityMilestonePlanConvert.INSTANCE.toDo(payload);
        return CrmOpportunityMilestonePlanConvert.INSTANCE.toVo((CrmOpportunityMilestonePlanDO)this.crmOpportunityMilestonePlanRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmOpportunityMilestonePlanVO update(CrmOpportunityMilestonePlanPayload payload) {
        CrmOpportunityMilestonePlanDO entity = this.crmOpportunityMilestonePlanRepo.findById(payload.getId()).orElseGet(CrmOpportunityMilestonePlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmOpportunityMilestonePlanDO entityDo = CrmOpportunityMilestonePlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmOpportunityMilestonePlanConvert.INSTANCE.toVo((CrmOpportunityMilestonePlanDO)this.crmOpportunityMilestonePlanRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CrmOpportunityMilestonePlanPayload payload) {
        CrmOpportunityMilestonePlanDO entity = this.crmOpportunityMilestonePlanRepo.findById(payload.getId()).orElseGet(CrmOpportunityMilestonePlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.crmOpportunityMilestonePlanDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.crmOpportunityMilestonePlanDAO.deleteSoft(keys);
        }
    }

    public void publish(Long id) {
        CrmOpportunityMilestonePlanVO crmOpportunityMilestonePlanVO = this.crmOpportunityMilestonePlanDAO.queryByKey(id);
        crmOpportunityMilestonePlanVO = (CrmOpportunityMilestonePlanVO)this.udcUtil.translate(crmOpportunityMilestonePlanVO);
        Long oppoId = crmOpportunityMilestonePlanVO.getOppoId();
        CrmOpportunityVO crmOpportunityVO = this.crmOpportunityDAO.queryByKey(oppoId);
        Long deliUserId = crmOpportunityVO.getDeliUserId();
        String deliUser = this.cacheUtil.getUserName(deliUserId);
        if (deliUserId == null) {
            throw TwException.error("", "\u8bf7\u5148\u5728\u57fa\u672c\u4fe1\u606f\u4e2d\u9009\u62e9\u4ea4\u4ed8\u8d1f\u8d23\u4eba");
        }
        try {
            String noticeSource = deliUserId.toString();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("deliUser", deliUser);
            data.put("oppoName", crmOpportunityVO.getProjectName());
            data.put("milestone", crmOpportunityMilestonePlanVO.getMilestoneDesc());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("M\u6708d\u65e5", Locale.CHINA);
            data.put("dateFrom", crmOpportunityMilestonePlanVO.getDateFrom().format(formatter));
            data.put("dateTo", crmOpportunityMilestonePlanVO.getDateTo().format(formatter));
            PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20231101001501");
            this.messageConfigService.sendMessageConfig(configVO, data, "appoint_people", noticeSource);
            log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            log.info("\u90ae\u4ef6\u53d1\u9001\u51fa\u73b0\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public CrmOpportunityMilestonePlanServiceImpl(CrmOpportunityMilestonePlanRepo crmOpportunityMilestonePlanRepo, CrmOpportunityMilestonePlanDAO crmOpportunityMilestonePlanDAO, CrmOpportunityDAO crmOpportunityDAO, PrdMessageConfigService messageConfigService, CacheUtil cacheUtil, UdcUtil udcUtil) {
        this.crmOpportunityMilestonePlanRepo = crmOpportunityMilestonePlanRepo;
        this.crmOpportunityMilestonePlanDAO = crmOpportunityMilestonePlanDAO;
        this.crmOpportunityDAO = crmOpportunityDAO;
        this.messageConfigService = messageConfigService;
        this.cacheUtil = cacheUtil;
        this.udcUtil = udcUtil;
    }
}

