/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonRewardPunishPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonRewardPunishService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonRewardPunishVO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonRewardPunishConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonRewardPunishDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonRewardPunishDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonRewardPunishRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PersonRewardPunishServiceImpl
implements PersonRewardPunishService {
    private static final Logger log = LoggerFactory.getLogger(PersonRewardPunishServiceImpl.class);
    private final PersonRewardPunishRepo personRewardPunishRepo;
    private final PersonRewardPunishDAO personRewardPunishDAO;

    public void save(PersonRewardPunishPayload save) {
        PersonRewardPunishDO personRewardPunishDO = PersonRewardPunishConvert.INSTANCE.toDo(save);
        this.personRewardPunishRepo.save((Object)personRewardPunishDO);
    }

    public List<PersonRewardPunishVO> findAllByPersonId(Long personId) {
        List<PersonRewardPunishDO> personRewardPunishDOList = this.personRewardPunishRepo.findAllByPersonId(personId);
        return PersonRewardPunishConvert.INSTANCE.toVos(personRewardPunishDOList);
    }

    public void saveAll(List<PersonRewardPunishVO> personRewardPunishVOList, Long personId) {
        if (personRewardPunishVOList != null) {
            if (personRewardPunishVOList.size() == 0) {
                this.personRewardPunishDAO.deleteAllByPersonId(personId);
            } else {
                for (PersonRewardPunishVO personRewardPunishVO : personRewardPunishVOList) {
                    if (personRewardPunishVO.getPersonId() != null) continue;
                    personRewardPunishVO.setPersonId(personId);
                }
                this.personRewardPunishDAO.saveAll(PersonRewardPunishConvert.INSTANCE.toDos(personRewardPunishVOList));
            }
        }
    }

    public void deleteAllByPersonId(Long personId) {
        this.personRewardPunishDAO.deleteAllByPersonId(personId);
    }

    public PersonRewardPunishServiceImpl(PersonRewardPunishRepo personRewardPunishRepo, PersonRewardPunishDAO personRewardPunishDAO) {
        this.personRewardPunishRepo = personRewardPunishRepo;
        this.personRewardPunishDAO = personRewardPunishDAO;
    }
}

