/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.query.MobAttendanceRuleQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRuleService;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceRuleVO;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRuleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6253\u5361\u89c4\u5219"})
@RestController
@RequestMapping(value={"/api/tAttendanceRules"})
public class TAttendanceRulesController {
    private static final Logger log = LoggerFactory.getLogger(TAttendanceRulesController.class);
    private final TAttendanceRuleService attendanceRuleService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u6253\u5361\u89c4\u5219\u5217\u8868")
    public TwOutputUtil<List<TAttendanceRuleVO>> getResAttendanceRuleList() {
        return TwOutputUtil.ok(this.attendanceRuleService.getAttendanceRule());
    }

    @GetMapping(value={"/getCurrentUser"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u4eba\u6240\u6709\u7684\u6253\u5361\u89c4\u5219")
    public TwOutputUtil<List<MobAttendanceRuleVO>> getResAttendanceRule() {
        Long userId = GlobalUtil.getLoginUserId();
        return TwOutputUtil.ok(this.attendanceRuleService.getAttendanceRule(userId.longValue()));
    }

    @PutMapping(value={"/attendance/res/todayAttendanceData"})
    @ApiOperation(value="\u8d44\u6e90\u6253\u5361\u7b7e\u5230")
    public TwOutputUtil resTodayAttendance(@RequestBody MobAttendanceVO vo) {
        Long userId = GlobalUtil.getLoginUserId();
        vo.setAttendanceResId(userId);
        return TwOutputUtil.ok(this.attendanceRuleService.resAttendanceInfo(vo));
    }

    @GetMapping(value={"/attendance/res/todayAttendanceData"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u4eba\u4eca\u65e5\u6253\u5361\u6570\u636e")
    public TwOutputUtil getResTodayAttendanceData() {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate attendanceDate = LocalDate.now();
        return TwOutputUtil.ok(this.attendanceRuleService.getResAttendanceInfo(userId, attendanceDate));
    }

    @GetMapping(value={"/attendance/res/log"})
    @ApiOperation(value="\u8d44\u6e90\u6253\u5361\u8bb0\u5f55")
    public TwOutputUtil getResAttendanceRule(MobAttendanceRuleQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        return TwOutputUtil.ok(this.attendanceRuleService.resAttendanceLog(userId.longValue(), query.getAttendanceDateStart(), query.getAttendanceDateEnd()));
    }

    @PutMapping(value={"/attendance/res/reason"})
    @ApiOperation(value="\u6253\u5361\u5f02\u5e38\u66f4\u65b0\u8bf4\u660e")
    public TwOutputUtil getResAttendanceRule(TAttendanceNormalVO vo) {
        return TwOutputUtil.ok(this.attendanceRuleService.resAttendanceReason(vo));
    }

    @PostMapping(value={"/attendance/information/update"})
    @ApiOperation(value="\u6253\u5361\u7ed3\u679c\u66f4\u65b0")
    public TwOutputUtil updateAttendacneInformation(@DateTimeFormat(pattern="yyyy-MM-dd") LocalDate date) {
        this.attendanceRuleService.updateAttendanceInformation(date);
        return TwOutputUtil.ok();
    }

    public TAttendanceRulesController(TAttendanceRuleService attendanceRuleService) {
        this.attendanceRuleService = attendanceRuleService;
    }
}

