/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationDataPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgOrganizationRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgRolePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeRefConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgOrganizationConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgRoleConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdOrgOrganizationServiceImpl
implements PrdOrgOrganizationService {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgOrganizationServiceImpl.class);
    final String default_role_Code = "ORG-LEADER";
    private final PrdOrgOrganizationDAO dao;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final CacheUtil cacheUtil;
    private final CalAccountService calAccountService;
    @Value(value="${tw5.sys_default.dimensionId}")
    private Long default_dimension_id;

    @Transactional
    public PrdOrgOrganizationVO insert(PrdOrgOrganizationPayload payload) {
        int count = this.dao.queryAll(payload.getOrgCode(), null, null).size();
        if (count > 0) {
            throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        PrdOrgOrganizationDO ado = PrdOrgOrganizationConvert.INSTANCE.toDo(payload);
        ado = this.dao.save(ado);
        PrdOrgOrganizationRefDO refDao = new PrdOrgOrganizationRefDO();
        refDao.setOrgId(ado.getId());
        refDao.setDimensionId(ado.getDimensionId());
        refDao.setOrgType(1);
        refDao.setParentId(payload.getParentId());
        this.dao.saveRef(refDao);
        PrdOrgRoleDO roleDO = new PrdOrgRoleDO();
        roleDO.setOrgId(ado.getId());
        roleDO.setRoleCode("ORG-LEADER");
        roleDO.setRoleName("\u7ec4\u7ec7\u8d1f\u8d23\u4eba");
        if (payload.getManageId() != null && payload.getManageId() != 0L) {
            roleDO.setRoleEmployees("" + payload.getManageId());
        }
        this.dao.saveRole(roleDO);
        CalAccountPayload accountPayload = new CalAccountPayload();
        accountPayload.setAuType(CalAccTypeEnum.BU.getCode());
        accountPayload.setAuId(ado.getId());
        accountPayload.setLedgerName(ado.getOrgName());
        accountPayload.setLedgerNo(ado.getOrgCode());
        this.calAccountService.insert(accountPayload);
        return PrdOrgOrganizationConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(PrdOrgOrganizationPayload payload) {
        if (payload.getParentId() != null && payload.getParentId().longValue() == payload.getId().longValue()) {
            throw TwException.error("", "\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u53ef\u9009\u62e9\u81ea\u8eab\u7ec4\u7ec7");
        }
        List<PrdOrgOrganizationRefVO> refVOS = this.dao.queryAll(payload.getOrgCode(), null, null);
        if (refVOS.size() == 0 || refVOS.size() == 1 && refVOS.get(0).getOrgId().longValue() == payload.getId().longValue()) {
            PrdOrgOrganizationRefVO ovo = this.dao.queryByRefId(payload.getId());
            if (ovo != null && ovo.getDimensionId().longValue() == payload.getDimensionId().longValue()) {
                if (payload.getParentId() != null && payload.getParentId() > 0L) {
                    PrdOrgOrganizationRefPayload refPayload = new PrdOrgOrganizationRefPayload();
                    refPayload.setOrgId(payload.getId());
                    refPayload.setDimensionId(payload.getDimensionId());
                    refPayload.setParentId(payload.getParentId());
                    this.dao.updateRef(refPayload);
                }
                if (payload.getManageId() != null && payload.getManageId() != 0L) {
                    this.dao.updateRoleEmployees(payload.getId(), "ORG-LEADER", "" + payload.getManageId());
                }
                return this.dao.updateByKeyDynamic(payload);
            }
            throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        throw TwException.error("", "\u5f15\u7528\u7ec4\u7ec7\u4e0d\u53ef\u7f16\u8f91");
    }

    @Transactional
    public Long updateRef(PrdOrgOrganizationRefPayload payload) {
        return this.dao.updateRef(payload);
    }

    @Transactional
    public Long reference(PrdOrgOrganizationRefPayload payload) {
        if (payload.getParentId().longValue() == payload.getOrgId().longValue()) {
            throw TwException.error("", "\u5f15\u7528\u7ec4\u7ec7\u5173\u7cfb\u9519\u8bef");
        }
        PrdOrgOrganizationRefDO ordo = this.dao.queryByDimensionIdOrOrgId(payload.getDimensionId(), payload.getOrgId());
        if (ordo != null && ordo.getOrgType() == 2) {
            throw TwException.error("", "\u5f53\u524d\u7ef4\u5ea6\u4e0b\u5df2\u5b58\u5728\u8be5\u7ec4\u7ec7\u5f15\u7528\u5173\u7cfb");
        }
        PrdOrgOrganizationRefDO refDao = new PrdOrgOrganizationRefDO();
        refDao.setParentId(payload.getParentId());
        refDao.setOrgId(payload.getOrgId());
        refDao.setOrgType(2);
        refDao.setDimensionId(payload.getDimensionId());
        this.dao.saveRef(refDao);
        return 0L;
    }

    @Transactional
    public boolean deleteSoft(Long dimensionId, Long orgId) {
        PrdOrgOrganizationRefDO ordo = this.dao.queryByDimensionIdOrOrgId(dimensionId, orgId);
        if (ordo != null) {
            List<PrdOrgEmployeeRefVO> empList;
            PrdOrgOrganizationRefDO organizationRefDO;
            if (ordo.getOrgType() == 2) {
                this.dao.deleteRefSoft(ordo.getId());
                return true;
            }
            PrdOrgOrganizationDO organizationDO = this.dao.queryById(orgId);
            if (!(organizationDO.getOrgStatus().equalsIgnoreCase("active") || (organizationRefDO = this.dao.queryFirstByParentId(orgId)) != null || (empList = this.dao.queryEmployeeList(orgId)) != null && empList.size() != 0)) {
                this.dao.deleteAllRefSoft(orgId);
                this.dao.deleteSoft(orgId);
                return true;
            }
        }
        throw TwException.error("", "\u5220\u9664\u5931\u8d25\uff0c\u8be5\u7ec4\u7ec7\u5df2\u6fc0\u6d3b\u6216\u5b58\u5728\u4e0b\u5c5e\u5173\u7cfb");
    }

    public List<PrdOrgOrganizationRefVO> queryList(Long dimensionId) {
        if (dimensionId == null) {
            dimensionId = this.default_dimension_id;
        }
        List<PrdOrgOrganizationRefVO> organizationRefVOS = this.dao.queryOrgList(dimensionId, null);
        for (PrdOrgOrganizationRefVO rvo : organizationRefVOS) {
            Optional<PrdOrgEmployeeRefVO> first;
            List<PrdOrgEmployeeRefVO> refVOS = this.dao.queryEmployeeList(rvo.getOrgId());
            if (rvo.getManageId() != null && !(first = refVOS.stream().filter(a -> rvo.getManageId().longValue() == a.getUserId().longValue()).findFirst()).isEmpty()) {
                first.get().setIsManage(Integer.valueOf(0));
            }
            rvo.setOrgEmployees(refVOS);
        }
        return organizationRefVOS;
    }

    public List<PrdOrgOrganizationRefVO> queryList() {
        List<PrdOrgOrganizationRefVO> organizationRefVOS = this.dao.queryOrgList(-1L, null);
        return organizationRefVOS;
    }

    public List<PrdOrgOrganizationRefVO> queryAll(Long dimensionId, Boolean defaultFlag) {
        return this.dao.queryAll(null, dimensionId, defaultFlag);
    }

    public List<PrdOrgOrganizationRefVO> queryByOrgStatus(String orgStatus) {
        return this.dao.queryByOrgStatus(orgStatus);
    }

    public List<PrdOrgOrganizationVO> queryAllByQuery(PrdOrgOrganizationQuery query) {
        return this.dao.queryAll(query);
    }

    public PagingVO<PrdOrgOrganizationVO> paging(PrdOrgOrganizationQuery query) {
        return this.dao.queryPaging(query);
    }

    public List<PrdOrgEmployeeRefVO> queryEmployeeRefList(Long orgId) {
        return this.dao.queryEmployeeList(orgId);
    }

    public PrdOrgOrganizationVO queryDetail(Long dimensionId, Long orgId) {
        PrdOrgOrganizationRefDO ordo = this.dao.queryByDimensionIdOrOrgId(dimensionId, orgId);
        if (ordo != null) {
            PrdOrgOrganizationVO ovo = this.dao.queryOrgById(orgId);
            ovo.setOrgType(ordo.getOrgType());
            ovo.setParentId(ordo.getParentId());
            if (ovo != null) {
                List<PrdOrgRoleVO> roleVos = this.dao.queryRoleList(orgId);
                for (PrdOrgRoleVO role : roleVos) {
                    if (ObjectUtils.isEmpty((Object)role.getRoleEmployees())) continue;
                    String[] employeeStrs = role.getRoleEmployees().split(",");
                    ArrayList<Long> employeeIds = new ArrayList<Long>();
                    for (int i = 0; i < employeeStrs.length; ++i) {
                        employeeIds.add(Long.valueOf(employeeStrs[i]));
                    }
                    role.setOrgEmployees(this.dao.queryRoleEmployeeList(employeeIds));
                }
                ovo.setOrgRoles(roleVos);
                String selcetKey = "org:manage:status";
                PrdSystemSelectionVO view = this.cacheUtil.getSystemSelection(selcetKey);
                if (view != null && view.getChildren() != null && !view.getChildren().isEmpty()) {
                    List childrens = view.getChildren();
                    for (PrdSystemSelectionVO selectionVO : childrens) {
                        if (!selectionVO.getSelectionValue().equalsIgnoreCase(ovo.getOrgStatus())) continue;
                        ovo.setOrgStatusName(selectionVO.getSelectionName());
                        break;
                    }
                }
                return ovo;
            }
        }
        return null;
    }

    public PrdOrgRoleVO queryRoleByOrgIdAndRoleCode(Long orgId, String code) {
        return this.dao.queryRoleByOrgIdAndRoleCode(orgId, code);
    }

    public PrdOrgOrganizationVO queryDetailSimpleByOrgId(Long orgId) {
        PrdOrgOrganizationDO prdOrgOrganizationDO = this.dao.queryById(orgId);
        PrdOrgOrganizationVO prdOrgOrganizationVO = PrdOrgOrganizationConvert.INSTANCE.toVo(prdOrgOrganizationDO);
        return prdOrgOrganizationVO;
    }

    @Transactional
    public Long insertEmployeeRef(List<PrdOrgEmployeeRefPayload> payloads) {
        ArrayList<Long> employeeIds = new ArrayList<Long>();
        ArrayList<Long> employeeRemoveIds = new ArrayList<Long>();
        ArrayList<PrdOrgEmployeeRefDO> employeeRefDOs = new ArrayList<PrdOrgEmployeeRefDO>();
        for (PrdOrgEmployeeRefPayload payload : payloads) {
            if (payload.getParentId().longValue() == payload.getUserId().longValue()) {
                throw TwException.error("", "\u63d0\u4ea4\u4e0a\u7ea7\u6570\u636e\u5f02\u5e38");
            }
            PrdOrgEmployeeRefDO ado = this.dao.queryByOrgIdAndEmpId(payload.getOrgId(), payload.getUserId());
            if (ado != null) continue;
            if (payload.getIsDefault() == 0) {
                employeeIds.add(payload.getUserId());
            }
            if (payload.getIsRemove() == 0) {
                employeeRemoveIds.add(payload.getUserId());
            }
            ado = PrdOrgEmployeeRefConvert.INSTANCE.toDo(payload);
            ado.setJoinDate(LocalDate.now());
            employeeRefDOs.add(ado);
        }
        if (employeeRemoveIds.size() > 0) {
            this.dao.updateEmployeeRefFlag(employeeRemoveIds);
        }
        if (employeeIds.size() > 0) {
            this.dao.updateEmployeeRefStatus(employeeIds);
        }
        if (employeeRefDOs.size() > 0) {
            this.dao.saveEmployeeRef(employeeRefDOs);
        }
        return 0L;
    }

    @Transactional
    public boolean deleteEmployeeRefSoft(Long orgId, List<Long> userIds) {
        long num = this.dao.deleteEmployeeRefSoft(orgId, userIds);
        if (num < (long)userIds.size()) {
            throw TwException.error("", "\u5458\u5de5\u9ed8\u8ba4\u7ec4\u7ec7\u4e0d\u53ef\u88ab\u79fb\u9664");
        }
        return true;
    }

    @Transactional
    public PrdOrgRoleVO insertRole(PrdOrgRolePayload payload) {
        PrdOrgRoleDO ado = PrdOrgRoleConvert.INSTANCE.toDo(payload);
        this.dao.saveRole(ado);
        return PrdOrgRoleConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long updateRole(PrdOrgRolePayload payload) {
        if (payload.getRoleCode() != null && !payload.getRoleCode().equals("ORG-LEADER")) {
            if (payload.getId() == null || payload.getId() == 0L || this.dao.queryRoleByKey(payload.getId()) == null) {
                PrdOrgRoleDO ado = PrdOrgRoleConvert.INSTANCE.toDo(payload);
                this.dao.saveRole(ado);
            } else {
                this.dao.updateRole(payload);
            }
        }
        return 0L;
    }

    @Transactional
    public Boolean deleteRoleSoft(Long key) {
        return this.dao.deleteRoleSoft(key) >= 0L;
    }

    @Transactional
    public Long updateStatus(Long id, String orgStatus) {
        if (id != null && StringUtils.hasText((String)orgStatus)) {
            PrdOrgOrganizationVO pvo;
            if (orgStatus.equalsIgnoreCase("active") && (pvo = this.dao.queryParentOrgById(id)) != null && !pvo.getOrgStatus().equalsIgnoreCase("active")) {
                throw TwException.error("", "\u4e0a\u7ea7\u7ec4\u7ec7\u662f\u975e\u6fc0\u6d3b\u72b6\u6001");
            }
        } else {
            throw TwException.error("", "\u53c2\u6570\u9519\u8bef id\uff1a" + id + " orgStatus\uff1a" + orgStatus);
        }
        this.dao.updateStatus(id, orgStatus);
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public Long updateOrgOrEmpRef(List<PrdOrgOrganizationDataPayload> payloads) {
        void var6_10;
        ArrayList<Long> orgRefIds = new ArrayList<Long>();
        ArrayList<Long> empRefIds = new ArrayList<Long>();
        HashMap<Long, PrdOrgOrganizationDataPayload> mapDatas = new HashMap<Long, PrdOrgOrganizationDataPayload>();
        for (PrdOrgOrganizationDataPayload prdOrgOrganizationDataPayload : payloads) {
            if (prdOrgOrganizationDataPayload.getDataType().equals("org")) {
                orgRefIds.add(prdOrgOrganizationDataPayload.getId());
            } else {
                empRefIds.add(prdOrgOrganizationDataPayload.getId());
            }
            mapDatas.put(prdOrgOrganizationDataPayload.getId(), prdOrgOrganizationDataPayload);
        }
        List<Object> orgRefDOs = new ArrayList();
        if (orgRefIds.size() > 0) {
            orgRefDOs = this.dao.queryByOrgRefIds(orgRefIds);
        }
        for (PrdOrgOrganizationRefDO orgRefDO : orgRefDOs) {
            PrdOrgOrganizationDataPayload payload = (PrdOrgOrganizationDataPayload)mapDatas.get(orgRefDO.getId());
            Long parentId = orgRefDO.getParentId() == null ? 0L : orgRefDO.getParentId();
            if (payload.getChangeId().longValue() == parentId.longValue() && payload.getSortIndex().intValue() == orgRefDO.getSortIndex().intValue()) continue;
            orgRefDO.setParentId(payload.getChangeId());
            orgRefDO.setSortIndex(payload.getSortIndex());
            this.dao.updateOrgRef(orgRefDO);
        }
        ArrayList arrayList = new ArrayList();
        if (empRefIds.size() > 0) {
            List<PrdOrgEmployeeRefDO> list = this.dao.queryByEmployeeRefIds(empRefIds);
        }
        for (PrdOrgEmployeeRefDO empRefDO : var6_10) {
            PrdOrgOrganizationDataPayload payload = (PrdOrgOrganizationDataPayload)mapDatas.get(empRefDO.getId());
            if (payload.getChangeId().longValue() == empRefDO.getOrgId().longValue() && payload.getSortIndex().intValue() == empRefDO.getSortIndex().intValue()) continue;
            empRefDO.setOrgId(payload.getChangeId());
            empRefDO.setSortIndex(payload.getSortIndex());
            this.dao.updateEmployeeRef(empRefDO);
        }
        return 0L;
    }

    public Map<Long, String> queryOrgs(List<Long> orgIds) {
        List<Map<String, Object>> orgs = this.dao.queryOrgs(orgIds);
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        orgs.forEach(org -> orgMap.put(Long.valueOf("" + org.get("id")), (String)org.get("orgName")));
        return orgMap;
    }

    public Map<Long, Long> getV4AndV5OrgIds() {
        HashMap<Long, Long> orgMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5OrgIds = this.dao.getV4AndV5OrgIds();
        for (Map<String, Object> v4AndV5OrgId : v4AndV5OrgIds) {
            Long orgId = (Long)v4AndV5OrgId.get("orgId");
            Long orgIdV4 = (Long)v4AndV5OrgId.get("orgIdV4");
            if (orgId == null || orgIdV4 == null) continue;
            orgMap.put(orgIdV4, orgId);
        }
        return orgMap;
    }

    public List<PrdOrgDataRefVO> queryOrgRefList() {
        return this.employeeDAO.queryOrgList();
    }

    public List<PrdOrgRoleVO> queryRoleList() {
        return this.dao.queryRoleList(null);
    }

    public List<Long> queryByManageIdOrgIds(Long userId) {
        return this.dao.queryByManageIdOrgIds(userId);
    }

    public List<PrdOrgOrganizationVO> queryByManageIdOrgs(Long userId) {
        return this.dao.queryByManageIdOrgs(userId);
    }

    public List<PrdOrgOrganizationRefVO> queryOrgRoleList(Long dimensionId) {
        List<PrdOrgOrganizationRefVO> organizationRefVOS;
        List<Long> orgIds;
        List<PrdOrgRoleVO> prdOrgRoleVOS;
        if (dimensionId == null) {
            dimensionId = this.default_dimension_id;
        }
        if (!ObjectUtils.isEmpty(prdOrgRoleVOS = this.dao.queryRolesByOrgIds(orgIds = (organizationRefVOS = this.dao.queryOrgList(dimensionId, null)).stream().map(PrdOrgOrganizationRefVO::getOrgId).collect(Collectors.toList())))) {
            Map<Long, List<PrdOrgRoleVO>> roleMap = prdOrgRoleVOS.stream().collect(Collectors.groupingBy(PrdOrgRoleVO::getOrgId));
            organizationRefVOS.forEach(vo -> vo.setOrgRoles((List)roleMap.get(vo.getOrgId())));
        }
        return organizationRefVOS;
    }

    public List<PrdOrgRoleVO> queryRolesByDimensionId(Long dimensionId) {
        if (dimensionId == null) {
            dimensionId = this.default_dimension_id;
        }
        return this.dao.queryRolesByDimensionId(dimensionId);
    }

    public List<PrdOrgRoleVO> queryUserOrgRoles(Long userId) {
        if (userId == null) {
            userId = GlobalUtil.getLoginUserId();
        }
        return this.dao.queryRolesByUserId(userId);
    }

    public Long queryManageIdById(Long id) {
        return this.dao.queryManageIdById(id);
    }

    public List<PrdOrgOrganizationRefVO> queryAllChildOrgByUserId(Long userId) {
        List<PrdOrgOrganizationRefVO> prdOrgOrganizationRefVOS = this.queryList();
        ArrayList<PrdOrgOrganizationRefVO> childList = new ArrayList<PrdOrgOrganizationRefVO>();
        if (!CollectionUtils.isEmpty(prdOrgOrganizationRefVOS)) {
            List<PrdOrgOrganizationRefVO> orgList = prdOrgOrganizationRefVOS.stream().filter(p -> p.getManageId().equals(userId)).collect(Collectors.toList());
            Map<Long, List<PrdOrgOrganizationRefVO>> orgMap = prdOrgOrganizationRefVOS.stream().filter(p -> p.getParentId() != null).collect(Collectors.groupingBy(PrdOrgOrganizationRefVO::getParentId));
            this.getChildOrgList(orgList, childList, orgMap);
            return childList;
        }
        return null;
    }

    public List<PrdOrgOrganizationRefVO> queryAllChildOrgByOrgId(Long orgId) {
        List<PrdOrgOrganizationRefVO> prdOrgOrganizationRefVOS = this.queryList();
        ArrayList<PrdOrgOrganizationRefVO> childList = new ArrayList<PrdOrgOrganizationRefVO>();
        if (!CollectionUtils.isEmpty(prdOrgOrganizationRefVOS)) {
            List<PrdOrgOrganizationRefVO> orgList = prdOrgOrganizationRefVOS.stream().filter(p -> p.getOrgId().equals(orgId)).collect(Collectors.toList());
            Map<Long, List<PrdOrgOrganizationRefVO>> orgMap = prdOrgOrganizationRefVOS.stream().filter(p -> p.getParentId() != null).collect(Collectors.groupingBy(PrdOrgOrganizationRefVO::getParentId));
            this.getChildOrgList(orgList, childList, orgMap);
            return childList;
        }
        return null;
    }

    public List<Long> queryAllOrgIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS;
        if (userId == null) {
            userId = GlobalUtil.getLoginUserId();
        }
        if ((prdOrgEmployeeRefVOS = this.employeeDAO.queryAllOrgRefByUserId(userId)).size() > 0) {
            List collect = prdOrgEmployeeRefVOS.stream().map(PrdOrgEmployeeRefVO::getOrgId).collect(Collectors.toList());
            Set<Long> orgIds = this.dao.queryAllChildOrgs((Set)((Object)collect));
            orgIds.addAll(collect);
            return new ArrayList<Long>(orgIds);
        }
        return new ArrayList<Long>();
    }

    public List<PrdOrgOrganizationRefVO> queryAllFatherOrgByOrgId(Long orgId) {
        List<PrdOrgOrganizationRefVO> prdOrgOrganizationRefVOS = this.queryList();
        ArrayList<PrdOrgOrganizationRefVO> fatherList = new ArrayList<PrdOrgOrganizationRefVO>();
        if (!CollectionUtils.isEmpty(prdOrgOrganizationRefVOS)) {
            List<PrdOrgOrganizationRefVO> orgList = prdOrgOrganizationRefVOS.stream().filter(p -> p.getOrgId().equals(orgId)).collect(Collectors.toList());
            Map<Long, List<PrdOrgOrganizationRefVO>> orgMap = prdOrgOrganizationRefVOS.stream().filter(p -> p.getOrgId() != null).collect(Collectors.groupingBy(PrdOrgOrganizationRefVO::getOrgId));
            this.getFatherOrgList(orgList, fatherList, orgMap);
            return fatherList;
        }
        return null;
    }

    public void getChildOrgList(List<PrdOrgOrganizationRefVO> orgList, List<PrdOrgOrganizationRefVO> childList, Map<Long, List<PrdOrgOrganizationRefVO>> orgMap) {
        if (!CollectionUtils.isEmpty(orgList)) {
            childList.addAll(orgList);
            ArrayList<PrdOrgOrganizationRefVO> list = new ArrayList<PrdOrgOrganizationRefVO>();
            orgList.stream().forEach(p -> {
                if (orgMap.containsKey(p.getOrgId())) {
                    list.addAll((Collection)orgMap.get(p.getOrgId()));
                }
            });
            if (!CollectionUtils.isEmpty(list)) {
                this.getChildOrgList(list, childList, orgMap);
            }
        }
    }

    public void getFatherOrgList(List<PrdOrgOrganizationRefVO> orgList, List<PrdOrgOrganizationRefVO> fatherList, Map<Long, List<PrdOrgOrganizationRefVO>> orgMap) {
        if (!CollectionUtils.isEmpty(orgList)) {
            fatherList.addAll(orgList);
            ArrayList<PrdOrgOrganizationRefVO> list = new ArrayList<PrdOrgOrganizationRefVO>();
            orgList.stream().forEach(p -> {
                if (orgMap.containsKey(p.getParentId()) && p.getParentId() != null && p.getParentId() != 0L && !p.getParentId().equals(p.getId())) {
                    list.addAll((Collection)orgMap.get(p.getParentId()));
                }
            });
            if (!CollectionUtils.isEmpty(list)) {
                this.getFatherOrgList(list, fatherList, orgMap);
            }
        }
    }

    public Boolean containCheck(Long userId, String orgIds) {
        ArrayList<PrdOrgOrganizationRefVO> orgIdAll = new ArrayList<PrdOrgOrganizationRefVO>();
        List orgIdList = Arrays.stream(orgIds.split(",")).map(e -> Long.parseLong(e)).collect(Collectors.toList());
        for (Long orgId : orgIdList) {
            List<PrdOrgOrganizationRefVO> prdOrgOrganizationRefVOS = this.queryAllChildOrgByOrgId(orgId);
            orgIdAll.addAll(prdOrgOrganizationRefVOS);
        }
        List orgIdAllList = orgIdAll.stream().map(e -> e.getOrgId()).collect(Collectors.toList());
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.employeeDAO.queryUserOrgDataList();
        for (PrdOrgEmployeeRefVO prdOrgEmployeeRefVO : prdOrgEmployeeRefVOS) {
            if (!orgIdAllList.contains(prdOrgEmployeeRefVO.getOrgId()) || !prdOrgEmployeeRefVO.getUserId().equals(userId)) continue;
            return true;
        }
        return false;
    }

    public PrdOrgOrganizationServiceImpl(PrdOrgOrganizationDAO dao, PrdOrgEmployeeDAO employeeDAO, CacheUtil cacheUtil, CalAccountService calAccountService) {
        this.dao = dao;
        this.employeeDAO = employeeDAO;
        this.cacheUtil = cacheUtil;
        this.calAccountService = calAccountService;
    }
}

