/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.identity.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessCustomerSyncPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerListSimpleQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessCutomerManageVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookAddressDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessInsideOrOutSideEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessCollaboratePartnerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessDistributorInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessSupplierInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCustomerInfoRepo;
import com.elitesland.tw.tw5.server.prd.partner.team.entity.QBusinessTeamMemberDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class BusinessCustomerInfoDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessCustomerInfoRepo repo;
    private final QBusinessCustomerInfoDO qdo = QBusinessCustomerInfoDO.businessCustomerInfoDO;
    private final QBusinessDistributorInfoDO qBusinessDistributorInfoDO = QBusinessDistributorInfoDO.businessDistributorInfoDO;
    private final QBusinessSupplierInfoDO qBusinessSupplierInfoDO = QBusinessSupplierInfoDO.businessSupplierInfoDO;
    private final QBusinessCollaboratePartnerInfoDO qBusinessCollaboratePartnerInfoDO = QBusinessCollaboratePartnerInfoDO.businessCollaboratePartnerInfoDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBookAddressDO qBookAddressDO = QBookAddressDO.bookAddressDO;
    private final QCrmLeadsDO qCrmLeadsDO = QCrmLeadsDO.crmLeadsDO;
    private final QCrmOpportunityDO qCrmOpportunityDO = QCrmOpportunityDO.crmOpportunityDO;
    private final QBusinessTeamMemberDO qBusinessTeamMemberDO = QBusinessTeamMemberDO.businessTeamMemberDO;
    private final QCrmCustomerOperationDO qCrmCustomerOperationDO = QCrmCustomerOperationDO.crmCustomerOperationDO;

    private JPAQuery<BusinessCustomerInfoVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessCustomerInfoVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.customerNo, this.qdo.syncJdeFlag, this.qdo.createUserId, this.qdo.createTime, this.qdo.partnerId, this.qdo.customerStatus, this.qdo.customerGradle, this.qdo.customerSource, this.qdo.isOperate, this.qdo.customerStage, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5, this.qdo.score, this.qdo.strategyId})).from((EntityPath)this.qdo);
    }

    private JPAQuery<BusinessCustomerInfoVO> getJpaQueryWhere(BusinessCustomerInfoQuery query) {
        JPAQuery<BusinessCustomerInfoVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(BusinessCustomerInfoQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BusinessCustomerInfoQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerId())) {
            list.add(this.qdo.partnerId.eq((Object)query.getPartnerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerNo())) {
            list.add(this.qdo.customerNo.eq((Object)query.getCustomerNo()));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getPartnerIdList())) {
            list.add(this.qdo.partnerId.in((Collection)query.getPartnerIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerStatus())) {
            list.add(this.qdo.customerStatus.eq((Object)query.getCustomerStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerGradle())) {
            list.add(this.qdo.customerGradle.eq((Object)query.getCustomerGradle()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerSource())) {
            list.add(this.qdo.customerSource.eq((Object)query.getCustomerSource()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerStage())) {
            list.add(this.qdo.customerStage.eq((Object)query.getCustomerStage()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustOperStatus())) {
            list.add(this.qCrmCustomerOperationDO.custOperStatus.eq((Object)query.getCustOperStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add(this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add(this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add(this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add(this.qdo.ext5.eq((Object)query.getExt5()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getScore())) {
            list.add(this.qdo.score.eq((Object)query.getScore()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStrategyId())) {
            list.add(this.qdo.strategyId.eq((Object)query.getStrategyId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BusinessCustomerInfoVO queryByKey(Long id) {
        JPAQuery<BusinessCustomerInfoVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BusinessCustomerInfoVO)jpaQuery.fetchFirst();
    }

    public List<BusinessCustomerInfoVO> queryListDynamic(BusinessCustomerInfoQuery query) {
        JPAQuery<BusinessCustomerInfoVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BusinessCustomerInfoVO> queryPaging(BusinessCustomerInfoQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BusinessCustomerInfoVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BusinessCustomerInfoDO save(BusinessCustomerInfoDO ado) {
        return (BusinessCustomerInfoDO)this.repo.save(ado);
    }

    public List<BusinessCustomerInfoDO> saveAll(List<BusinessCustomerInfoDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BusinessCustomerInfoPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getPartnerId() != null) {
            update.set(this.qdo.partnerId, (Object)payload.getPartnerId());
        }
        if (payload.getCustomerNo() != null) {
            update.set((Path)this.qdo.customerNo, (Object)payload.getCustomerNo());
        }
        if (payload.getSyncJdeFlag() != null) {
            update.set((Path)this.qdo.syncJdeFlag, (Object)payload.getSyncJdeFlag());
        }
        if (payload.getCustomerStatus() != null) {
            update.set((Path)this.qdo.customerStatus, (Object)payload.getCustomerStatus());
        }
        if (payload.getCustomerGradle() != null) {
            update.set((Path)this.qdo.customerGradle, (Object)payload.getCustomerGradle());
        }
        if (payload.getCustomerSource() != null) {
            update.set((Path)this.qdo.customerSource, (Object)payload.getCustomerSource());
        }
        if (payload.getIsOperate() != null) {
            update.set((Path)this.qdo.isOperate, (Object)payload.getIsOperate());
        }
        if (payload.getCustomerStage() != null) {
            update.set((Path)this.qdo.customerStage, (Object)payload.getCustomerStage());
        }
        if (payload.getProcInstId() != null) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if (payload.getScore() != null) {
            update.set(this.qdo.score, (Object)payload.getScore());
        }
        if (payload.getStrategyId() != null) {
            update.set(this.qdo.strategyId, (Object)payload.getStrategyId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("partnerId")) {
                update.setNull(this.qdo.partnerId);
            }
            if (nullFields.contains("customerNo")) {
                update.setNull((Path)this.qdo.customerNo);
            }
            if (nullFields.contains("syncJdeFlag")) {
                update.setNull((Path)this.qdo.syncJdeFlag);
            }
            if (nullFields.contains("customerStatus")) {
                update.setNull((Path)this.qdo.customerStatus);
            }
            if (nullFields.contains("customerGradle")) {
                update.setNull((Path)this.qdo.customerGradle);
            }
            if (nullFields.contains("customerSource")) {
                update.setNull((Path)this.qdo.customerSource);
            }
            if (nullFields.contains("isOperate")) {
                update.setNull((Path)this.qdo.isOperate);
            }
            if (nullFields.contains("customerStage")) {
                update.setNull((Path)this.qdo.customerStage);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
            if (nullFields.contains("score")) {
                update.setNull(this.qdo.score);
            }
            if (nullFields.contains("strategyId")) {
                update.setNull(this.qdo.strategyId);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull((Path)this.qdo.procInstId);
            }
            if (nullFields.contains("procInstStatus")) {
                update.setNull(this.qdo.procInstStatus);
            }
            if (nullFields.contains("submitTime")) {
                update.setNull(this.qdo.submitTime);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<BusinessCustomerSimpleVO> listSimple(String identity, String customerStatus) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessCustomerSimpleVO.class, (Expression[])new Expression[]{this.qBusinessPartnerDO.bookId, this.qBusinessPartnerDO.id, this.qBusinessPartnerDO.businessPartnerNo, this.qBusinessPartnerDO.partnerName.as("customerName"), this.qBusinessPartnerDO.partnerIndustry.as("companyIndustry"), this.qBusinessPartnerDO.partnerNature, this.qBusinessPartnerDO.partnerRegion, this.qBusinessPartnerDO.ext4, this.qBusinessPartnerDO.ext5, this.qBusinessPartnerDO.sortNo})).from((EntityPath)this.qBusinessPartnerDO);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)identity) && BusinessPartnerIdentityEnum.CUSTOMER.getCode().equals(identity)) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qdo)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qdo.partnerId));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)customerStatus)) {
                jpaQuery.where((Predicate)this.qdo.customerStatus.eq((Object)customerStatus));
            }
            jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)identity) && BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode().equals(identity)) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessDistributorInfoDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qBusinessDistributorInfoDO.partnerId));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)customerStatus) && BusinessPartnerStatusEnum.ACTIVE.getCode().equals(customerStatus)) {
                jpaQuery.where((Predicate)this.qBusinessDistributorInfoDO.dealerStatus.eq((Object)customerStatus));
            }
            jpaQuery.where((Predicate)this.qBusinessDistributorInfoDO.deleteFlag.eq((Object)0));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)identity) && BusinessPartnerIdentityEnum.SUPPLIER.getCode().equals(identity)) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessSupplierInfoDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qBusinessSupplierInfoDO.partnerId));
            jpaQuery.where((Predicate)this.qBusinessSupplierInfoDO.deleteFlag.eq((Object)0));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)customerStatus)) {
                jpaQuery.where((Predicate)this.qBusinessSupplierInfoDO.supplierStatus.eq((Object)customerStatus));
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)identity) && BusinessPartnerIdentityEnum.COLLABORATE.getCode().equals(identity)) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessCollaboratePartnerInfoDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qBusinessCollaboratePartnerInfoDO.partnerId));
            jpaQuery.where((Predicate)this.qBusinessCollaboratePartnerInfoDO.deleteFlag.eq((Object)0));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)customerStatus)) {
                jpaQuery.where((Predicate)this.qBusinessCollaboratePartnerInfoDO.collaborateStatus.eq((Object)customerStatus));
            }
        }
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        orders.add(OrderItem.asc((String)"sortNo"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qBusinessPartnerDO, orders));
        return jpaQuery.fetch();
    }

    public Long listSimplePagingCount(BusinessPartnerListSimpleQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qBusinessPartnerDO.count()).from((EntityPath)this.qBusinessPartnerDO);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.CUSTOMER.getCode().equals(query.getPartnerIdentity())) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qdo)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qdo.partnerId));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getCustomerStatus())) {
                jpaQuery.where((Predicate)this.qdo.customerStatus.eq((Object)query.getCustomerStatus()));
            }
            jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode().equals(query.getPartnerIdentity())) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessDistributorInfoDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qBusinessDistributorInfoDO.partnerId));
            jpaQuery.where((Predicate)this.qBusinessDistributorInfoDO.deleteFlag.eq((Object)0));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getCustomerStatus())) {
                jpaQuery.where((Predicate)this.qBusinessDistributorInfoDO.dealerStatus.eq((Object)query.getCustomerStatus()));
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.SUPPLIER.getCode().equals(query.getPartnerIdentity())) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessSupplierInfoDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qBusinessSupplierInfoDO.partnerId));
            jpaQuery.where((Predicate)this.qBusinessSupplierInfoDO.deleteFlag.eq((Object)0));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getCustomerStatus())) {
                jpaQuery.where((Predicate)this.qBusinessSupplierInfoDO.supplierStatus.eq((Object)query.getCustomerStatus()));
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.COLLABORATE.getCode().equals(query.getPartnerIdentity())) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessCollaboratePartnerInfoDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qBusinessCollaboratePartnerInfoDO.partnerId));
            jpaQuery.where((Predicate)this.qBusinessCollaboratePartnerInfoDO.deleteFlag.eq((Object)0));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getCustomerStatus())) {
                jpaQuery.where((Predicate)this.qBusinessCollaboratePartnerInfoDO.collaborateStatus.eq((Object)query.getCustomerStatus()));
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getPartnerName())) {
            jpaQuery.where((Predicate)this.qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(query.getPartnerName())));
        }
        jpaQuery.where((Predicate)this.qBusinessPartnerDO.insideOrOutSide.eq((Object)BusinessInsideOrOutSideEnum.OUTSIDE.getCode()));
        Long total = (Long)jpaQuery.fetchOne();
        if (total == null) {
            total = 0L;
        }
        return total;
    }

    public PagingVO<BusinessCustomerSimpleVO> listSimplePaging(BusinessPartnerListSimpleQuery query) {
        Long total = this.listSimplePagingCount(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessCustomerSimpleVO.class, (Expression[])new Expression[]{this.qBusinessPartnerDO.bookId, this.qBusinessPartnerDO.id, this.qBusinessPartnerDO.businessPartnerNo, this.qBusinessPartnerDO.partnerName.as("customerName"), this.qBusinessPartnerDO.partnerIndustry.as("companyIndustry")})).from((EntityPath)this.qBusinessPartnerDO);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.CUSTOMER.getCode().equals(query.getPartnerIdentity())) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qdo)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qdo.partnerId));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getCustomerStatus())) {
                jpaQuery.where((Predicate)this.qdo.customerStatus.eq((Object)query.getCustomerStatus()));
            }
            jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode().equals(query.getPartnerIdentity())) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessDistributorInfoDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qBusinessDistributorInfoDO.partnerId));
            jpaQuery.where((Predicate)this.qBusinessDistributorInfoDO.deleteFlag.eq((Object)0));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getCustomerStatus())) {
                jpaQuery.where((Predicate)this.qBusinessDistributorInfoDO.dealerStatus.eq((Object)query.getCustomerStatus()));
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.SUPPLIER.getCode().equals(query.getPartnerIdentity())) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessSupplierInfoDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qBusinessSupplierInfoDO.partnerId));
            jpaQuery.where((Predicate)this.qBusinessSupplierInfoDO.deleteFlag.eq((Object)0));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getCustomerStatus())) {
                jpaQuery.where((Predicate)this.qBusinessSupplierInfoDO.supplierStatus.eq((Object)query.getCustomerStatus()));
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getPartnerIdentity()) && BusinessPartnerIdentityEnum.COLLABORATE.getCode().equals(query.getPartnerIdentity())) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessCollaboratePartnerInfoDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qBusinessCollaboratePartnerInfoDO.partnerId));
            jpaQuery.where((Predicate)this.qBusinessCollaboratePartnerInfoDO.deleteFlag.eq((Object)0));
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getCustomerStatus())) {
                jpaQuery.where((Predicate)this.qBusinessCollaboratePartnerInfoDO.collaborateStatus.eq((Object)query.getCustomerStatus()));
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)query.getPartnerName())) {
            jpaQuery.where((Predicate)this.qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(query.getPartnerName())));
        }
        jpaQuery.where((Predicate)this.qBusinessPartnerDO.insideOrOutSide.eq((Object)BusinessInsideOrOutSideEnum.OUTSIDE.getCode()));
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total.longValue()).build();
    }

    public CrmCustomerSimpleVO listSimpleByPartnerId(Long partnerId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustomerSimpleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qBusinessPartnerDO.bookId, this.qBusinessPartnerDO.id.as("partnerId"), this.qBusinessPartnerDO.partnerName.as("customerName"), this.qdo.customerStatus, this.qdo.customerGradle, this.qdo.customerSource, this.qBookAddressDO.longitudeLatitude, this.qBookAddressDO.detailAddress.as("companyAddress")})).from((EntityPath)this.qBusinessPartnerDO)).leftJoin((EntityPath)this.qdo)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessPartnerDO.id))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBusinessPartnerDO.bookId.eq(this.qBookAddressDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.TRUE)).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0)));
        jpaQuery.where((Predicate)this.qBusinessPartnerDO.id.eq((Object)partnerId));
        return (CrmCustomerSimpleVO)jpaQuery.fetchOne();
    }

    public List<BusinessStrategyCustomerVO> queryCustomerList(BusinessPartnerQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessStrategyCustomerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qBusinessPartnerDO.id.as("partnerId"), this.qBusinessPartnerDO.partnerNature, this.qBusinessPartnerDO.organizationScale, this.qCrmCustomerOperationDO.companyTightness, this.qCrmCustomerOperationDO.industryStand, this.qCrmCustomerOperationDO.businessStrategy})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessPartnerDO.id))).leftJoin((EntityPath)this.qCrmCustomerOperationDO)).on((Predicate)this.qdo.partnerId.eq(this.qCrmCustomerOperationDO.customerId).and((Predicate)this.qCrmCustomerOperationDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBookAddressDO.bookId.eq(this.qBusinessPartnerDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true))))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qBusinessPartnerDO.deleteFlag.eq((Object)0));
        if (!CollectionUtils.isEmpty((Collection)query.getPartnerNatureList())) {
            jpaQuery.where((Predicate)this.qBusinessPartnerDO.partnerNature.in((Collection)query.getPartnerNatureList()));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getPartnerIndustryList())) {
            jpaQuery.where((Predicate)this.qBusinessPartnerDO.partnerIndustry.in((Collection)query.getPartnerIndustryList()));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getCountryList())) {
            jpaQuery.where((Predicate)this.qBookAddressDO.country.in((Collection)query.getCountryList()));
        }
        return jpaQuery.fetch();
    }

    public void updateCustomerGrade() {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).setNull((Path)this.qdo.customerGradle).setNull(this.qdo.score).setNull((Path)this.qdo.indexInfo).where(new Predicate[]{this.qdo.deleteFlag.eq((Object)0)});
        update.execute();
    }

    public long queryCustomerManageCount(BusinessCustomerInfoQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.countDistinct()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessPartnerDO.id))).leftJoin((EntityPath)this.qCrmCustomerOperationDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qCrmCustomerOperationDO.customerId).and((Predicate)this.qCrmCustomerOperationDO.deleteFlag.eq((Object)0)));
        if (query.getPermissionFlag().booleanValue()) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessTeamMemberDO)).on((Predicate)this.qBusinessTeamMemberDO.objectId.longValue().eq(this.qdo.partnerId));
        }
        jpaQuery.where(this.queryCustomerManageWhere(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    public JPAQuery<BusinessCutomerManageVO> queryCustomerManageSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessCutomerManageVO.class, (Expression[])new Expression[]{this.qBusinessPartnerDO.id, this.qdo.customerNo, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qBusinessPartnerDO.bookId, this.qBusinessPartnerDO.businessPartnerNo, this.qBusinessPartnerDO.partnerType, this.qBusinessPartnerDO.partnerName, this.qdo.isOperate, this.qdo.customerGradle, this.qdo.customerStatus, this.qdo.customerStage, this.qBusinessPartnerDO.partnerIndustry, this.qdo.customerSource, this.qBusinessPartnerDO.partnerEmail, this.qBusinessPartnerDO.partnerFax, this.qBusinessPartnerDO.partnerPhone, this.qBookAddressDO.country, this.qBookAddressDO.province, this.qBookAddressDO.city, this.qBookAddressDO.district, this.qBookAddressDO.provinceName, this.qBookAddressDO.cityName, this.qBookAddressDO.districtName, this.qBookAddressDO.detailAddress, this.qCrmCustomerOperationDO.custOperStatus})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessPartnerDO.id))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBusinessPartnerDO.bookId.eq(this.qBookAddressDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true))).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qCrmCustomerOperationDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qCrmCustomerOperationDO.customerId).and((Predicate)this.qCrmCustomerOperationDO.deleteFlag.eq((Object)0)));
    }

    private Predicate queryCustomerManageWhere(BusinessCustomerInfoQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.qBusinessPartnerDO.deleteFlag.eq((Object)0));
        if (!ObjectUtils.isEmpty((Object)query.getPartnerName())) {
            list.add(this.qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(query.getPartnerName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerGradle())) {
            list.add(this.qdo.customerGradle.eq((Object)query.getCustomerGradle()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerStatus())) {
            list.add(this.qdo.customerStatus.eq((Object)query.getCustomerStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerIndustry())) {
            list.add(this.qBusinessPartnerDO.partnerIndustry.eq((Object)query.getPartnerIndustry()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerSource())) {
            list.add(this.qdo.customerSource.eq((Object)query.getCustomerSource()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerStage())) {
            list.add(this.qdo.customerStage.eq((Object)query.getCustomerStage()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustOperStatus())) {
            list.add(this.qCrmCustomerOperationDO.custOperStatus.eq((Object)query.getCustOperStatus()));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getIdList())) {
            list.add(this.qBusinessPartnerDO.id.in((Collection)query.getIdList()));
        }
        if (query.getPermissionFlag().booleanValue()) {
            BooleanExpression booleanExpression = this.qBusinessTeamMemberDO.userId.eq((Object)query.getLoginUserId()).and((Predicate)this.qBusinessTeamMemberDO.deleteFlag.eq((Object)0));
            booleanExpression = booleanExpression.or((Predicate)this.qdo.createUserId.eq((Object)query.getLoginUserId()));
            list.add(booleanExpression);
        }
        return ExpressionUtils.allOf(list);
    }

    public PagingVO<BusinessCutomerManageVO> queryCustomerManage(BusinessCustomerInfoQuery query) {
        long total = this.queryCustomerManageCount(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BusinessCutomerManageVO> jpaQuery = this.queryCustomerManageSelect();
        if (query.getPermissionFlag().booleanValue()) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessTeamMemberDO)).on((Predicate)this.qBusinessTeamMemberDO.objectId.longValue().eq(this.qdo.partnerId));
        }
        jpaQuery.distinct();
        jpaQuery.where(this.queryCustomerManageWhere(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public List<BusinessCutomerManageVO> queryCustomerManageList(BusinessCustomerInfoQuery query) {
        JPAQuery<BusinessCutomerManageVO> jpaQuery = this.queryCustomerManageSelect();
        if (query.getPermissionFlag().booleanValue()) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qBusinessTeamMemberDO)).on((Predicate)this.qBusinessTeamMemberDO.objectId.longValue().eq(this.qdo.partnerId));
        }
        jpaQuery.distinct();
        jpaQuery.where(this.queryCustomerManageWhere(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    public BusinessCutomerManageVO queryCustomerManageByPartnerId(Long id) {
        return (BusinessCutomerManageVO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessCutomerManageVO.class, (Expression[])new Expression[]{this.qBusinessPartnerDO.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qBusinessPartnerDO.bookId, this.qBusinessPartnerDO.businessPartnerNo, this.qBusinessPartnerDO.partnerType, this.qBusinessPartnerDO.partnerName, this.qdo.isOperate, this.qdo.customerGradle, this.qdo.customerStatus, this.qdo.customerStage, this.qBusinessPartnerDO.partnerIndustry, this.qdo.customerSource, this.qBusinessPartnerDO.partnerEmail, this.qBusinessPartnerDO.partnerFax, this.qBusinessPartnerDO.partnerPhone})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessPartnerDO.id))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetchFirst();
    }

    public List<BusinessCustomerSyncPayload> queryBusinessCustomerSyncTw4(String businessPartnerNo) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessCustomerSyncPayload.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.customerStatus, this.qBusinessPartnerDO.bookIdV4, this.qBusinessTeamMemberDO.memberName.as("operationUserName")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessPartnerDO.id))).leftJoin((EntityPath)this.qBusinessTeamMemberDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessTeamMemberDO.objectId).and((Predicate)this.qBusinessTeamMemberDO.deleteFlag.eq((Object)0)).and((Predicate)this.qBusinessTeamMemberDO.memberRole.eq((Object)BusinessTeamRoleEnum.OPERATION.getCode())))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qBusinessPartnerDO.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.syncTime.lt(this.qdo.modifyTime).or((Predicate)this.qdo.syncTime.isNull()))).where((Predicate)this.qBusinessPartnerDO.insideOrOutSide.eq((Object)BusinessInsideOrOutSideEnum.OUTSIDE.getCode()));
        if (StringUtils.hasText((String)businessPartnerNo)) {
            jpaQuery.where((Predicate)this.qBusinessPartnerDO.businessPartnerNo.eq((Object)businessPartnerNo));
        }
        return jpaQuery.fetch();
    }

    public void updateSyncUpdateCustomer(List<Long> idList) {
        this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.syncTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qdo.id.in(idList)}).execute();
    }

    public void updateBusinessParnerCustomerModifyTime(Long partnerId) {
        this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.modifyTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qdo.partnerId.eq((Object)partnerId)}).execute();
    }

    public List<BusinessCustomerSimpleVO> queryInnerCompany() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessCustomerSimpleVO.class, (Expression[])new Expression[]{this.qBusinessPartnerDO.bookId, this.qBusinessPartnerDO.businessPartnerNo, this.qBusinessPartnerDO.id, this.qBusinessPartnerDO.partnerName.as("customerName"), this.qBusinessPartnerDO.partnerIndustry.as("companyIndustry"), this.qBusinessPartnerDO.ext4, this.qBusinessPartnerDO.ext5, this.qBusinessPartnerDO.sortNo})).from((EntityPath)this.qBusinessPartnerDO)).where((Predicate)this.qBusinessPartnerDO.insideOrOutSide.eq((Object)BusinessInsideOrOutSideEnum.INSIDE.getCode()))).where((Predicate)this.qBusinessPartnerDO.disabledFlag.isNull().or((Predicate)this.qBusinessPartnerDO.disabledFlag.eq((Object)0)))).where((Predicate)this.qBusinessPartnerDO.deleteFlag.eq((Object)0));
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        orders.add(OrderItem.asc((String)"sortNo"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qBusinessPartnerDO, orders));
        return jpaQuery.fetch();
    }

    public BusinessCustomerInfoDAO(JPAQueryFactory jpaQueryFactory, BusinessCustomerInfoRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

