/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessModelIndexSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessModelIndexSettingService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexSettingVO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessStrategyIndexEnum;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessModelIndexSettingConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessModelIndexSettingDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessModelIndexSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessModelIndexSettingRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BusinessModelIndexSettingServiceImpl
extends BaseServiceImpl
implements BusinessModelIndexSettingService {
    private static final Logger log = LoggerFactory.getLogger(BusinessModelIndexSettingServiceImpl.class);
    private final BusinessModelIndexSettingRepo businessModelIndexSettingRepo;
    private final BusinessModelIndexSettingDAO businessModelIndexSettingDAO;

    public PagingVO<BusinessModelIndexSettingVO> queryPaging(BusinessModelIndexSettingQuery query) {
        return this.businessModelIndexSettingDAO.queryPaging(query);
    }

    public List<BusinessModelIndexSettingVO> queryListDynamic(BusinessModelIndexSettingQuery query) {
        List<BusinessModelIndexSettingVO> businessModelIndexSettingVOS = this.businessModelIndexSettingDAO.queryListDynamic(query);
        businessModelIndexSettingVOS.forEach(vo -> vo.setSourceFiledDesc(BusinessStrategyIndexEnum.valueOf(vo.getSourceFiled()).getDesc()));
        return businessModelIndexSettingVOS;
    }

    public BusinessModelIndexSettingVO queryByKey(Long key) {
        BusinessModelIndexSettingDO entity = this.businessModelIndexSettingRepo.findById(key).orElseGet(BusinessModelIndexSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessModelIndexSettingVO vo = BusinessModelIndexSettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessModelIndexSettingVO insert(BusinessModelIndexSettingPayload payload) {
        BusinessModelIndexSettingDO entityDo = BusinessModelIndexSettingConvert.INSTANCE.toDo(payload);
        return BusinessModelIndexSettingConvert.INSTANCE.toVo((BusinessModelIndexSettingDO)this.businessModelIndexSettingRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessModelIndexSettingVO update(BusinessModelIndexSettingPayload payload) {
        BusinessModelIndexSettingDO entity = this.businessModelIndexSettingRepo.findById(payload.getId()).orElseGet(BusinessModelIndexSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessModelIndexSettingDO entityDo = BusinessModelIndexSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessModelIndexSettingConvert.INSTANCE.toVo((BusinessModelIndexSettingDO)this.businessModelIndexSettingRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessModelIndexSettingPayload payload) {
        BusinessModelIndexSettingDO entity = this.businessModelIndexSettingRepo.findById(payload.getId()).orElseGet(BusinessModelIndexSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessModelIndexSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessModelIndexSettingDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByModelIndexId(Long modelIndexId) {
        this.businessModelIndexSettingDAO.deleteSoftByModelIndexId(modelIndexId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByModelId(Long modelId) {
        this.businessModelIndexSettingDAO.deleteSoftByModelId(modelId);
    }

    public BusinessModelIndexSettingServiceImpl(BusinessModelIndexSettingRepo businessModelIndexSettingRepo, BusinessModelIndexSettingDAO businessModelIndexSettingDAO) {
        this.businessModelIndexSettingRepo = businessModelIndexSettingRepo;
        this.businessModelIndexSettingDAO = businessModelIndexSettingDAO;
    }
}

