/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectMembersVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectMembersRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsProjectMembersDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectMembersRepo repo;
    private final QPmsProjectMembersDO qdo = QPmsProjectMembersDO.pmsProjectMembersDO;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    private JPAQuery<PmsProjectMembersVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectMembersVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.createTime, this.qdo.projId, this.qdo.role, this.qdo.capasetLevelId, this.qdo.resId, this.qdo.planStartDate, this.qdo.planEndDate, this.qdo.planEqva, this.qdo.workbenchFlag, this.qdo.customerPrice})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdo.resId.eq(this.qdoEmployee.userId));
    }

    private JPAQuery<PmsProjectMembersVO> getJpaQueryWhere(PmsProjectMembersQuery query) {
        JPAQuery<PmsProjectMembersVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.asc((String)"createTime"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, orderse));
        jpaQuery.groupBy(this.qdo.resId);
        return jpaQuery;
    }

    public long count(PmsProjectMembersQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdo.resId.eq(this.qdoEmployee.userId));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        Long total = (Long)jpaQuery.fetchOne();
        total = total == null ? 0L : total;
        return total;
    }

    private Predicate where(PmsProjectMembersQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjId())) {
            list.add(this.qdo.projId.eq((Object)query.getProjId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRole())) {
            list.add(this.qdo.role.eq((Object)query.getRole()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCapasetLevelId())) {
            list.add(this.qdo.capasetLevelId.eq((Object)query.getCapasetLevelId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getResId())) {
            list.add(this.qdo.resId.eq((Object)query.getResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanStartDate())) {
            list.add(this.qdo.planStartDate.eq((Object)query.getPlanStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanEndDate())) {
            list.add(this.qdo.planEndDate.eq((Object)query.getPlanEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanEqva())) {
            list.add(this.qdo.planEqva.eq((Object)query.getPlanEqva()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkbenchFlag())) {
            list.add(this.qdo.workbenchFlag.eq((Object)query.getWorkbenchFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerPrice())) {
            list.add(this.qdo.customerPrice.eq((Object)query.getCustomerPrice()));
        }
        list.add(this.qdoEmployee.deleteFlag.eq((Object)0));
        list.add(this.qdoEmployee.hrStatus.eq((Object)SystemDefaultEnum.DefaultHrStatus.getCode()));
        list.add(this.qdoEmployee.resourceStatus.ne((Object)SystemDefaultEnum.LeavedResourceStatus.getCode()));
        return ExpressionUtils.allOf(list);
    }

    public PmsProjectMembersVO queryByKey(Long id) {
        JPAQuery<PmsProjectMembersVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectMembersVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectMembersVO> queryByKeys(List<Long> ids) {
        JPAQuery<PmsProjectMembersVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PmsProjectMembersVO queryByProjAndRes(Long projId, Long resId) {
        JPAQuery<PmsProjectMembersVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projId.eq((Object)projId));
        jpaQuery.where((Predicate)this.qdo.resId.eq((Object)resId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectMembersVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectMembersVO> queryListDynamic(PmsProjectMembersQuery query) {
        JPAQuery<PmsProjectMembersVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsProjectMembersVO> queryPaging(PmsProjectMembersQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectMembersVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsProjectMembersDO save(PmsProjectMembersDO ado) {
        return (PmsProjectMembersDO)this.repo.save(ado);
    }

    public List<PmsProjectMembersDO> saveAll(List<PmsProjectMembersDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsProjectMembersPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getProjId() != null) {
            update.set(this.qdo.projId, (Object)payload.getProjId());
        }
        if (payload.getRole() != null) {
            update.set((Path)this.qdo.role, (Object)payload.getRole());
        }
        if (payload.getCapasetLevelId() != null) {
            update.set(this.qdo.capasetLevelId, (Object)payload.getCapasetLevelId());
        }
        if (payload.getResId() != null) {
            update.set(this.qdo.resId, (Object)payload.getResId());
        }
        if (payload.getPlanStartDate() != null) {
            update.set(this.qdo.planStartDate, (Object)payload.getPlanStartDate());
        }
        if (payload.getPlanEndDate() != null) {
            update.set(this.qdo.planEndDate, (Object)payload.getPlanEndDate());
        }
        if (payload.getPlanEqva() != null) {
            update.set(this.qdo.planEqva, (Object)payload.getPlanEqva());
        }
        if (payload.getWorkbenchFlag() != null) {
            update.set(this.qdo.workbenchFlag, (Object)payload.getWorkbenchFlag());
        }
        if (payload.getCustomerPrice() != null) {
            update.set(this.qdo.customerPrice, (Object)payload.getCustomerPrice());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("projId")) {
                update.setNull(this.qdo.projId);
            }
            if (nullFields.contains("role")) {
                update.setNull((Path)this.qdo.role);
            }
            if (nullFields.contains("capasetLevelId")) {
                update.setNull(this.qdo.capasetLevelId);
            }
            if (nullFields.contains("resId")) {
                update.setNull(this.qdo.resId);
            }
            if (nullFields.contains("planStartDate")) {
                update.setNull(this.qdo.planStartDate);
            }
            if (nullFields.contains("planEndDate")) {
                update.setNull(this.qdo.planEndDate);
            }
            if (nullFields.contains("planEqva")) {
                update.setNull(this.qdo.planEqva);
            }
            if (nullFields.contains("workbenchFlag")) {
                update.setNull(this.qdo.workbenchFlag);
            }
            if (nullFields.contains("customerPrice")) {
                update.setNull(this.qdo.customerPrice);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsProjectMembersDAO(JPAQueryFactory jpaQueryFactory, PmsProjectMembersRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

