/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalWideSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalWideSettleService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.pms.payload.BuProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTurTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.BuProjectConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.BuProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.BuProjectMembersDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.BuProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.BuProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.BuProjectRepo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class BuProjectServiceImpl
extends BaseServiceImpl
implements BuProjectService {
    private static final Logger log = LoggerFactory.getLogger(BuProjectServiceImpl.class);
    private final BuProjectRepo buProjectRepo;
    private final BuProjectDAO buProjectDAO;
    private final CalAccountService calAccountService;
    private final CacheUtil cacheUtil;
    private final CalWideSettleService calWideSettleService;
    private final TransactionUtilService transactionUtilService;
    private final PrdOrgOrganizationService serviceOrg;
    private final BuProjectMembersDAO buProjectMembersDAO;

    @Transactional(rollbackFor={Exception.class})
    public BuProjectVO insertOrUpdate(BuProjectPayload payload) {
        this.checkData(payload);
        BuProjectVO buProjectVO = this.buProjectDAO.queryByBuIdAndYear(payload.getBuId(), payload.getProjYear());
        if (!(buProjectVO == null || payload.getId() != null && payload.getId().equals(buProjectVO.getId()))) {
            throw TwException.error("", "BU\u5df2\u5b58\u5728" + payload.getProjYear() + "\u5e74\u7ecf\u8425\u9879\u76ee");
        }
        if (payload.getId() == null) {
            String code = this.generateSeqNum("PMS_PROJECT", new String[0]);
            payload.setProjNo(code);
        }
        payload.setAutoReportFlag(Integer.valueOf(0));
        payload.setDeliBuId(payload.getBuId());
        payload.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        BuProjectDO entityDo = BuProjectConvert.INSTANCE.toDo(payload);
        BuProjectDO save = (BuProjectDO)this.buProjectRepo.save(entityDo);
        if (payload.getId() == null) {
            this.createMembers(save.getId(), payload.getBuId());
            this.createAccount(save);
            this.transactionUtilService.executeWithRunnable(() -> this.createProjInitWideSettle(save));
        }
        return BuProjectConvert.INSTANCE.toVo(save);
    }

    void createMembers(Long projId, Long orgId) {
        List prdOrgEmployeeRefVOS = this.serviceOrg.queryEmployeeRefList(orgId);
        ArrayList<BuProjectMembersDO> buProjectMembersDOs = new ArrayList<BuProjectMembersDO>();
        prdOrgEmployeeRefVOS.forEach(emp -> {
            BuProjectMembersDO membersDO = new BuProjectMembersDO();
            membersDO.setProjId(projId);
            membersDO.setResId(emp.getUserId());
            membersDO.setWorkbenchFlag(1);
            buProjectMembersDOs.add(membersDO);
        });
        this.buProjectMembersDAO.saveAll(buProjectMembersDOs);
    }

    void createAccount(BuProjectDO entityDo) {
        CalAccountPayload accountPayload = new CalAccountPayload();
        accountPayload.setAuType(CalAccTypeEnum.BU_PROJ.getCode());
        accountPayload.setAuId(entityDo.getId());
        accountPayload.setLedgerName(entityDo.getProjName());
        accountPayload.setLedgerNo(entityDo.getProjNo());
        this.calAccountService.insert(accountPayload);
    }

    void createProjInitWideSettle(BuProjectDO projectDO) {
        CalWideSettlePayload settlePayload = new CalWideSettlePayload();
        settlePayload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
        settlePayload.setSettleType(CalAccTurTypeEnum.PROJ_INIT.getCode());
        settlePayload.setSettleDate(LocalDate.now());
        settlePayload.setFromSourceType(CalAccTypeEnum.BU.getCode());
        settlePayload.setFromSourceId(projectDO.getDeliBuId());
        settlePayload.setFromSourceName(this.cacheUtil.getOrgName(projectDO.getDeliBuId()));
        settlePayload.setToSourceType(CalAccTypeEnum.BU_PROJ.getCode());
        settlePayload.setToSourceId(projectDO.getId());
        settlePayload.setToSourceName(projectDO.getProjName());
        settlePayload.setApplySettleEqva(projectDO.getTotalEqva());
        settlePayload.setSettlePrice(projectDO.getEqvaPrice());
        settlePayload.setApplySettleAmt(projectDO.getTotalEqva().multiply(projectDO.getEqvaPrice()));
        settlePayload.setIsSubmit(Integer.valueOf(1));
        this.calWideSettleService.insertOrUpdate(settlePayload);
    }

    void checkData(BuProjectPayload payload) {
        if (payload.getBuId() == null) {
            throw TwException.error("", "BU\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getProjYear() == null) {
            throw TwException.error("", "\u5e74\u5ea6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getPmResId() == null) {
            throw TwException.error("", "\u9879\u76ee\u7ecf\u7406\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getDeliUserId() == null) {
            throw TwException.error("", "\u4ea4\u4ed8\u8d1f\u8d23\u4eba\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getEqvaPrice() == null) {
            throw TwException.error("", "\u5f53\u91cf\u9884\u4f30\u5355\u4ef7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getTotalEqva() == null || payload.getTotalEqva().compareTo(BigDecimal.ZERO) < 0) {
            throw TwException.error("", "\u9884\u8ba1\u603b\u5f53\u91cf\u9700\u5927\u4e8e\u7b49\u4e8e0");
        }
        if (payload.getTotalReimbursement() == null || payload.getTotalReimbursement().compareTo(BigDecimal.ZERO) < 0) {
            throw TwException.error("", "\u9884\u8ba1\u603b\u8d39\u7528\u9700\u5927\u4e8e\u7b49\u4e8e0");
        }
    }

    public PagingVO<BuProjectVO> queryPaging(BuProjectQuery query) {
        this.operPermissionFlag(query);
        PagingVO<BuProjectVO> buProjectVOPagingVO = this.buProjectDAO.queryPaging(query);
        if (buProjectVOPagingVO.getTotal() > 0L) {
            buProjectVOPagingVO.getRecords().forEach(vo -> vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId())));
        }
        return buProjectVOPagingVO;
    }

    void operPermissionFlag(BuProjectQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setLoginUserId(loginUserId);
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
    }

    public List<BuProjectVO> queryListDynamic(BuProjectQuery query) {
        if (!StringUtils.hasText((String)query.getProjStatus())) {
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setLoginUserId(loginUserId);
        return this.buProjectDAO.queryListDynamic(query);
    }

    public List<BuProjectVO> listByMember(BuProjectQuery query) {
        if (!StringUtils.hasText((String)query.getProjStatus())) {
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setLoginUserId(loginUserId);
        query.setProjYear(Integer.valueOf(LocalDate.now().getYear()));
        this.operPermissionFlag(query);
        return this.buProjectDAO.queryListDynamic(query);
    }

    public BuProjectVO queryByKey(Long key) {
        return this.buProjectDAO.queryByKey(key);
    }

    public BuProjectServiceImpl(BuProjectRepo buProjectRepo, BuProjectDAO buProjectDAO, CalAccountService calAccountService, CacheUtil cacheUtil, CalWideSettleService calWideSettleService, TransactionUtilService transactionUtilService, PrdOrgOrganizationService serviceOrg, BuProjectMembersDAO buProjectMembersDAO) {
        this.buProjectRepo = buProjectRepo;
        this.buProjectDAO = buProjectDAO;
        this.calAccountService = calAccountService;
        this.cacheUtil = cacheUtil;
        this.calWideSettleService = calWideSettleService;
        this.transactionUtilService = transactionUtilService;
        this.serviceOrg = serviceOrg;
        this.buProjectMembersDAO = buProjectMembersDAO;
    }
}

