/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.workflow;

import cn.hutool.json.JSONUtil;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetAppropriationService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsInnerProjectApplyService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectBriefService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectConclusionService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/PMS_{procDefKey}/callBack"})
@Transactional
public class PmsWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PmsWorkflowCallBackController.class);
    private final PmsProjectBriefService pmsProjectBriefService;
    private final PmsDistributeService pmsDistributeService;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final PmsInnerProjectApplyService pmsInnerProjectApplyService;
    private final PmsProjectService pmsProjectService;
    private final BudgetService budgetService;
    private final BudgetAppropriationService budgetAppropriationService;
    private final TaskInfoService taskInfoService;
    private final PmsProjectConclusionService pmsProjectConclusionService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_ACTIVITY.getName())) {
            this.pmsProjectActivityService.taskCreated(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_INNER_PROJECT.getName())) {
            this.pmsInnerProjectApplyService.taskCreated(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_CLOSE.getName())) {
            log.info("\u8c03\u7528\u9879\u76ee\u7ed3\u9879\u6d41\u7a0b\u7684service");
            this.pmsProjectConclusionService.taskCreated(payload);
        }
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u4efb\u52a1\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570: {}", (Object)JSONUtil.toJsonStr((Object)payload));
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_REPORT.getName())) {
            log.info("\u8c03\u7528\u9879\u76ee\u6c47\u62a5\u7684service");
            this.pmsProjectBriefService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_DISTRIBUTE.getName())) {
            log.info("\u8c03\u7528\u9879\u76ee\u6307\u6d3e\u7684service");
            this.pmsDistributeService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_ACTIVITY.getName())) {
            log.info("\u8c03\u7528\u9879\u76ee\u6d3b\u52a8\u7684service");
            this.pmsProjectActivityService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_INNER_PROJECT.getName())) {
            log.info("\u8c03\u7528\u5185\u90e8\u9879\u76ee\u7533\u8bf7\u7684service");
            this.pmsInnerProjectApplyService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_CHANGE.getName())) {
            log.info("\u8c03\u7528\u9879\u76ee\u6c47\u62a5\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u6d41\u7a0b\u7684service");
            this.pmsProjectService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_APPLY_EXTERNAL.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_APPLY_INTERNAL.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_CHANGE.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BGCHANGE_OUT_EQV.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BGCHANGE_OUT_AMT.getName())) {
            log.info("\u8c03\u7528\u9884\u7b97\u5ba1\u6279 \u6216\u8005 \u9884\u7b97\u53d8\u66f4\u5ba1\u6279\u6d41\u7a0b\u7684service");
            this.budgetService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_ALLOCAT_EXTERNAL.getName()) || payload.getProcDefKey().equals(PmsProcDefKey.PMS_BUDGET_ALLOCAT_INTERNAL.getName())) {
            log.info("\u8c03\u7528\u9884\u7b97\u62e8\u4ed8\u5ba1\u6279\u6d41\u7a0b\u7684service");
            this.budgetAppropriationService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_TASK_APPLY.getName())) {
            log.info("\u8c03\u7528\u4efb\u52a1\u7533\u8bf7\u6d41\u7a0b\u7684service");
            this.taskInfoService.processStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_TASK_CHANGE.getName())) {
            log.info("\u8c03\u7528\u4efb\u52a1\u53d8\u66f4\u6d41\u7a0b\u7684service");
            this.taskInfoService.processChangeStatusChange(payload);
        }
        if (payload.getProcDefKey().equals(PmsProcDefKey.PMS_PROJECT_CLOSE.getName())) {
            log.info("\u8c03\u7528\u9879\u76ee\u7ed3\u9879\u6d41\u7a0b\u7684service");
            this.pmsProjectConclusionService.processStatusChange(payload);
        }
        return WorkflowResult.success(null);
    }

    public PmsWorkflowCallBackController(PmsProjectBriefService pmsProjectBriefService, PmsDistributeService pmsDistributeService, PmsProjectActivityService pmsProjectActivityService, PmsInnerProjectApplyService pmsInnerProjectApplyService, PmsProjectService pmsProjectService, BudgetService budgetService, BudgetAppropriationService budgetAppropriationService, TaskInfoService taskInfoService, PmsProjectConclusionService pmsProjectConclusionService) {
        this.pmsProjectBriefService = pmsProjectBriefService;
        this.pmsDistributeService = pmsDistributeService;
        this.pmsProjectActivityService = pmsProjectActivityService;
        this.pmsInnerProjectApplyService = pmsInnerProjectApplyService;
        this.pmsProjectService = pmsProjectService;
        this.budgetService = budgetService;
        this.budgetAppropriationService = budgetAppropriationService;
        this.taskInfoService = taskInfoService;
        this.pmsProjectConclusionService = pmsProjectConclusionService;
    }
}

