/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConTemplatePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConTemplateQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConTemplateService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConTemplateVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConTemplateConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConTemplateDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConTemplateDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConTemplateRepo;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ConTemplateServiceImpl
extends BaseServiceImpl
implements ConTemplateService {
    private static final Logger log = LoggerFactory.getLogger(ConTemplateServiceImpl.class);
    private final ConTemplateRepo conTemplateRepo;
    private final ConTemplateDAO conTemplateDAO;
    private final FileUtil fileUtil;

    public PagingVO<ConTemplateVO> queryPaging(ConTemplateQuery query) {
        PagingVO<ConTemplateVO> pagingVO = this.conTemplateDAO.queryPaging(query);
        List records = pagingVO.getRecords();
        records.forEach(e -> e.setFileData(this.fileUtil.getFileDatas(e.getFileCodes())));
        return pagingVO;
    }

    public List<ConTemplateVO> queryListDynamic(ConTemplateQuery query) {
        return this.conTemplateDAO.queryListDynamic(query);
    }

    public ConTemplateVO queryByKey(Long key) {
        ConTemplateDO entity = this.conTemplateRepo.findById(key).orElseGet(ConTemplateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConTemplateVO vo = ConTemplateConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConTemplateVO insert(ConTemplatePayload payload) {
        ConTemplateVO conTemplateVO = this.conTemplateDAO.selectInspect(payload.getName());
        if (conTemplateVO != null) {
            throw TwException.error("", "\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        ConTemplateDO entityDo = ConTemplateConvert.INSTANCE.toDo(payload);
        return ConTemplateConvert.INSTANCE.toVo((ConTemplateDO)this.conTemplateRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConTemplateVO update(ConTemplatePayload payload) {
        ConTemplateVO conTemplateVO = this.conTemplateDAO.selectInspect(payload.getName());
        if (conTemplateVO != null && !conTemplateVO.getId().equals(payload.getId())) {
            throw TwException.error("", "\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        ConTemplateDO entity = this.conTemplateRepo.findById(payload.getId()).orElseGet(ConTemplateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConTemplateDO entityDo = ConTemplateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConTemplateConvert.INSTANCE.toVo((ConTemplateDO)this.conTemplateRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conTemplateDAO.deleteSoft(keys);
        }
    }

    @Transactional
    public void deleteById(Long key) {
        this.conTemplateDAO.deleteSoft(Collections.singletonList(key));
    }

    public ConTemplateServiceImpl(ConTemplateRepo conTemplateRepo, ConTemplateDAO conTemplateDAO, FileUtil fileUtil) {
        this.conTemplateRepo = conTemplateRepo;
        this.conTemplateDAO = conTemplateDAO;
        this.fileUtil = fileUtil;
    }
}

