/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFinYearPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinYearQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemFinYearService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinYearVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemFinYearConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemFinYearDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFinYearDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFinYearRepo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PrdSystemFinYearServiceImpl
extends BaseServiceImpl
implements PrdSystemFinYearService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemFinYearServiceImpl.class);
    private final PrdSystemFinYearRepo prdSystemFinYearRepo;
    private final PrdSystemFinYearDAO prdSystemFinYearDAO;

    public PagingVO<PrdSystemFinYearVO> queryPaging(PrdSystemFinYearQuery query) {
        return this.prdSystemFinYearDAO.queryPaging(query);
    }

    public List<PrdSystemFinYearVO> queryListDynamic(PrdSystemFinYearQuery query) {
        return this.prdSystemFinYearDAO.queryListDynamic(query);
    }

    public PrdSystemFinYearVO queryByKey(Long key) {
        PrdSystemFinYearDO entity = this.prdSystemFinYearRepo.findById(key).orElseGet(PrdSystemFinYearDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemFinYearVO vo = PrdSystemFinYearConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemFinYearVO insert(PrdSystemFinYearPayload payload) {
        PrdSystemFinYearDO entityDo = PrdSystemFinYearConvert.INSTANCE.toDo(payload);
        return PrdSystemFinYearConvert.INSTANCE.toVo((PrdSystemFinYearDO)this.prdSystemFinYearRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemFinYearVO update(PrdSystemFinYearPayload payload) {
        PrdSystemFinYearDO entity = this.prdSystemFinYearRepo.findById(payload.getId()).orElseGet(PrdSystemFinYearDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemFinYearDO entityDo = PrdSystemFinYearConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdSystemFinYearConvert.INSTANCE.toVo((PrdSystemFinYearDO)this.prdSystemFinYearRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.prdSystemFinYearDAO.deleteSoft(keys);
        }
    }

    @Transactional
    public PrdSystemFinYearVO findByFinYear(Integer finYear) {
        PrdSystemFinYearDO prdSystemFinYearDO = this.prdSystemFinYearRepo.findPrdSystemFinYearDOByFinYearAndDeleteFlag(finYear, 0);
        if (prdSystemFinYearDO == null) {
            Date beginDate = new Date();
            Date endDate = new Date();
            String beginDateStr = finYear + "-01-01";
            String endDateStr = finYear + "-12-31";
            try {
                beginDate = new SimpleDateFormat("yyyy-MM-dd").parse(beginDateStr);
                endDate = new SimpleDateFormat("yyyy-MM-dd").parse(endDateStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            PrdSystemFinYearDO entityDo = new PrdSystemFinYearDO();
            entityDo.setFinYear(finYear);
            ZoneId zoneId = ZoneId.systemDefault();
            entityDo.setBeginDate(beginDate.toInstant().atZone(zoneId).toLocalDate());
            entityDo.setEndDate(endDate.toInstant().atZone(zoneId).toLocalDate());
            entityDo.setYearStatus("OPEN");
            PrdSystemFinYearDO save = this.prdSystemFinYearDAO.save(entityDo);
            return PrdSystemFinYearConvert.INSTANCE.toVo(save);
        }
        return PrdSystemFinYearConvert.INSTANCE.toVo(prdSystemFinYearDO);
    }

    public PrdSystemFinYearServiceImpl(PrdSystemFinYearRepo prdSystemFinYearRepo, PrdSystemFinYearDAO prdSystemFinYearDAO) {
        this.prdSystemFinYearRepo = prdSystemFinYearRepo;
        this.prdSystemFinYearDAO = prdSystemFinYearDAO;
    }
}

