/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemProblemFeedbackProcessPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackProcessQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackProcessService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackProcessVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemProblemFeedbackConvert;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemProblemFeedbackProcessConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemProblemFeedbackDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemProblemFeedbackProcessDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemProblemFeedbackProcessDO;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdSystemProblemFeedbackProcessServiceImpl
implements PrdSystemProblemFeedbackProcessService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemProblemFeedbackProcessServiceImpl.class);
    private final PrdSystemProblemFeedbackProcessDAO dao;
    private final PrdSystemProblemFeedbackDAO feedbackDAO;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleDAO roleDAO;
    private final PrdMessageConfigService messageConfigService;
    @Autowired
    private SysUserRpcService sysUserService;

    public List<PrdSystemProblemFeedbackProcessVO> queryList(PrdSystemProblemFeedbackProcessQuery query) {
        List<PrdSystemProblemFeedbackProcessVO> processVOS = this.dao.queryListDynamic(query);
        for (PrdSystemProblemFeedbackProcessVO process : processVOS) {
            process.setProcessTypeDesc(this.cacheUtil.transferSystemSelection("sys:problem_feedback:process_type", process.getProcessType()));
            SysUserDTO createUser = this.sysUserService.getById(process.getCreateUserId());
            process.setCreateUserName(createUser.getFirstName());
        }
        return processVOS;
    }

    @Transactional
    public PrdSystemProblemFeedbackProcessVO insert(PrdSystemProblemFeedbackProcessPayload payload) {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        String userName = userDetails == null ? "" : userDetails.getUser().getUsername();
        List<Long> messageToUserIds = null;
        PrdSystemProblemFeedbackProcessDO ado = PrdSystemProblemFeedbackProcessConvert.INSTANCE.toDo(payload);
        Long feedbackId = payload.getFeedbackId();
        PrdSystemProblemFeedbackVO feedbackVO = this.feedbackDAO.queryByKey(feedbackId);
        if (payload.getPageFlag() == 0) {
            ado.setProcessType("1");
            feedbackVO.setReplyStatus("2");
            messageToUserIds = feedbackVO.getDirectorUserId() != null ? Collections.singletonList(feedbackVO.getDirectorUserId()) : this.roleDAO.queryUserIdByRoleCode(RoleEnum.OPS.getCode());
        } else if (payload.getPageFlag() == 1) {
            ado.setProcessType("2");
            feedbackVO.setReplyStatus("1");
            messageToUserIds = Collections.singletonList(feedbackVO.getCreateUserId());
        }
        if (messageToUserIds != null) {
            String noticeSource = StringUtils.join(messageToUserIds, (String)",");
            PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20220711001504");
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("fromUser", userName);
            result.put("action", "\u65b0\u589e\u4e86");
            result.put("url", String.format("/basic/feedback/operationFeedback/operaFeedbackView?id=%s", feedbackVO.getId()));
            this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
        }
        ado = this.dao.save(ado);
        this.feedbackDAO.save(PrdSystemProblemFeedbackConvert.INSTANCE.toDo(feedbackVO));
        return PrdSystemProblemFeedbackProcessConvert.INSTANCE.toVo(ado);
    }

    public PrdSystemProblemFeedbackProcessServiceImpl(PrdSystemProblemFeedbackProcessDAO dao, PrdSystemProblemFeedbackDAO feedbackDAO, CacheUtil cacheUtil, PrdSystemRoleDAO roleDAO, PrdMessageConfigService messageConfigService) {
        this.dao = dao;
        this.feedbackDAO = feedbackDAO;
        this.cacheUtil = cacheUtil;
        this.roleDAO = roleDAO;
        this.messageConfigService = messageConfigService;
    }
}

