/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFieldObjRoleFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldObjRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionFieldObjRoleFunctionService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionFieldService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionFunctionObjectService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemNewFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldObjRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFunctionObjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleGroupRoleVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemPermissionFieldObjRoleFunctionConvert;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemRoleConvert;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemRoleGroupRoleConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemBusinessObjectDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionFieldObjRoleFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionFunctionObjectDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleGroupRoleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRoleMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemBusinessObjectRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionFieldObjRoleFunctionRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionFunctionObjectRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PrdSystemRoleServiceImpl
implements PrdSystemRoleService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemRoleServiceImpl.class);
    private final PrdSystemRoleDAO dao;
    private final PrdSystemPermissionFunctionObjectRepo functionObjectRepo;
    private final PrdSystemPermissionFunctionObjectService functionObjectService;
    private final PrdSystemPermissionFieldObjRoleFunctionRepo fieldObjRoleFunctionRepo;
    private final PrdSystemPermissionFieldObjRoleFunctionService fieldObjRoleFunctionService;
    private final PrdSystemBusinessObjectRepo businessObjectRepo;
    private final PrdSystemPermissionFieldService fieldService;
    private final RedisUtils redisUtils;
    private static final String FIELD_RULE_CACHE_PREFIX = "sys:permission:field:rule:";
    private static final String REPLACE_STR = "-";
    private static final String REPLACE_MENT = "";

    @Transactional
    public PrdSystemRoleVO insert(PrdSystemRolePayload payload) {
        if (this.dao.queryByCodeOrName(payload.getRoleCode(), payload.getRoleName()) != null) {
            throw TwException.error(REPLACE_MENT, "\u7f16\u53f7\u6216\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
        }
        PrdSystemRoleDO ado = PrdSystemRoleConvert.INSTANCE.toDo(payload);
        ado = this.dao.save(ado);
        if (payload.getMenuIds() != null && payload.getMenuIds().size() > 0) {
            ArrayList<PrdSystemRoleMenuDO> roleMenuDOS = new ArrayList<PrdSystemRoleMenuDO>();
            for (Long menuId : payload.getMenuIds()) {
                PrdSystemRoleMenuDO roleMenuDO = new PrdSystemRoleMenuDO();
                roleMenuDO.setMenuId(menuId);
                roleMenuDO.setRoleId(ado.getId());
                roleMenuDOS.add(roleMenuDO);
            }
            this.dao.saveRoleMenuAll(roleMenuDOS);
        }
        if (payload.getUserIds() != null && payload.getUserIds().size() > 0) {
            ArrayList<PrdSystemUserRoleDO> userDOS = new ArrayList<PrdSystemUserRoleDO>();
            for (Long userId : payload.getUserIds()) {
                PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                userDO.setUserId(userId);
                userDO.setRoleId(ado.getId());
                userDOS.add(userDO);
            }
            this.dao.saveUserRoleAll(userDOS);
        }
        if (payload.getRoleGroupId() != null) {
            PrdSystemRoleGroupRoleDO roleGroupRoleDO = new PrdSystemRoleGroupRoleDO();
            roleGroupRoleDO.setRoleId(ado.getId());
            roleGroupRoleDO.setRoleGroupId(payload.getRoleGroupId());
            this.dao.saveRoleGroupRole(roleGroupRoleDO);
        }
        return PrdSystemRoleConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(PrdSystemRolePayload payload) {
        PrdSystemRoleVO roleVO = this.dao.queryByCodeOrName(payload.getRoleCode(), payload.getRoleName());
        if (roleVO != null && roleVO.getId().longValue() != payload.getId().longValue()) {
            throw TwException.error(REPLACE_MENT, "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        this.dao.updateByKeyDynamic(payload);
        if (payload.getMenuIds() != null) {
            if (payload.getMenuIds().size() > 0) {
                ArrayList<PrdSystemRoleMenuDO> roleMenuDOS = new ArrayList<PrdSystemRoleMenuDO>();
                for (Long menuId : payload.getMenuIds()) {
                    PrdSystemRoleMenuDO roleMenuDO = new PrdSystemRoleMenuDO();
                    roleMenuDO.setMenuId(menuId);
                    roleMenuDO.setRoleId(payload.getId());
                    roleMenuDOS.add(roleMenuDO);
                }
                this.dao.deleteRoleMenusByRoleId(payload.getId());
                this.dao.saveRoleMenuAll(roleMenuDOS);
            } else {
                this.dao.deleteRoleMenusByRoleId(payload.getId());
            }
        }
        if (payload.getUserIds() != null) {
            if (payload.getUserIds().size() > 0) {
                ArrayList<PrdSystemUserRoleDO> userDOS = new ArrayList<PrdSystemUserRoleDO>();
                for (Long userId : payload.getUserIds()) {
                    PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                    userDO.setUserId(userId);
                    userDO.setRoleId(payload.getId());
                    userDOS.add(userDO);
                }
                this.dao.deleteRolesByUserId(payload.getId());
                this.dao.saveUserRoleAll(userDOS);
            } else {
                this.dao.deleteRolesByUserId(payload.getId());
            }
        }
        if (payload.getFunctionIds() != null) {
            if (payload.getFunctionIds().size() > 0) {
                ArrayList<PrdSystemRoleFunctionDO> functionDOS = new ArrayList<PrdSystemRoleFunctionDO>();
                for (Long functionId : payload.getFunctionIds()) {
                    PrdSystemRoleFunctionDO functionDO = new PrdSystemRoleFunctionDO();
                    functionDO.setFunctionId(functionId);
                    functionDO.setRoleId(payload.getId());
                    functionDOS.add(functionDO);
                }
                this.initialField(payload);
                this.dao.deleteRoleFunctionsByRoleId(payload.getId());
                this.dao.saveRoleFunctionAll(functionDOS);
            } else {
                this.dao.deleteRoleFunctionsByRoleId(payload.getId());
            }
        }
        if (!ObjectUtils.isEmpty((Object)payload.getRoleGroupId())) {
            PrdSystemRoleGroupRoleVO roleGroupRoleVO = this.dao.queryRoleGroupRoleByRoleId(payload.getId());
            Assert.notNull((Object)roleGroupRoleVO.getId(), (String)"\u4e0d\u5b58\u5728\u7684\u89d2\u8272\u7ec4\u5173\u7cfb");
            PrdSystemRoleGroupRoleDO roleGroupRoleDO = PrdSystemRoleGroupRoleConvert.INSTANCE.toDo(roleGroupRoleVO);
            roleGroupRoleDO.setRoleGroupId(payload.getRoleGroupId());
            this.dao.saveRoleGroupRole(roleGroupRoleDO);
        }
        return 0L;
    }

    @Transactional
    public Long updateStatus(Long id, Boolean enabled) {
        if (!ObjectUtils.isEmpty((Object)id) && !ObjectUtils.isEmpty((Object)enabled)) {
            this.dao.updateStatus(id, enabled);
            return 0L;
        }
        throw TwException.error(REPLACE_MENT, "\u53c2\u6570\u9519\u8bef");
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        this.dao.deleteSoft(keys);
        return true;
    }

    public PrdSystemRoleVO queryByKey(Long key) {
        PrdSystemRoleVO roleVO = this.dao.queryByKey(key);
        roleVO.setMenuIds(this.dao.queryRoleMenuIds(key));
        roleVO.setUserDatas(this.dao.queryUsers(key));
        roleVO.setRoleGroupId(this.dao.queryRoleGroupId(key));
        return roleVO;
    }

    public PagingVO<PrdSystemRoleVO> paging(PrdSystemRoleQuery query) {
        return this.dao.queryPaging(query);
    }

    public List<PrdSystemRoleVO> queryList() {
        return this.dao.queryList();
    }

    public List<Long> queryUserIdByRoleCode(String roleNo) {
        return this.dao.queryUserIdByRoleCode(roleNo);
    }

    public PagingVO<PrdOrgEmployeeVO> pagingUserList(PrdSystemRoleFunctionQuery query) {
        this.checkPagingUserList(query);
        return this.dao.queryPagingUserList(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteUserList(Long roleId, Long userId) {
        this.dao.deleteRoleByUserId(roleId, userId);
    }

    public PagingVO<PrdSystemRoleFunctionVO> pagingFunctionList(PrdSystemRoleFunctionQuery query) {
        this.checkPagingFunctionList(query);
        PagingVO<PrdSystemRoleFunctionVO> pagingVO = this.dao.queryByBusinessObject(query);
        List records = pagingVO.getRecords();
        for (PrdSystemRoleFunctionVO next : records) {
            List<PrdSystemNewFunctionVO> app = this.dao.queryByNewFunction(next.getId(), "APP");
            app.forEach(prdSystemNewFunctionVO -> prdSystemNewFunctionVO.setChecked(this.dao.queryByRoleFunction(query, (PrdSystemNewFunctionVO)prdSystemNewFunctionVO)));
            next.setApp(app);
            List<PrdSystemNewFunctionVO> pc = this.dao.queryByNewFunction(next.getId(), "PC");
            pc.forEach(prdSystemNewFunctionVO -> prdSystemNewFunctionVO.setChecked(this.dao.queryByRoleFunction(query, (PrdSystemNewFunctionVO)prdSystemNewFunctionVO)));
            next.setPc(pc);
        }
        pagingVO.setRecords(records);
        return pagingVO;
    }

    public PagingVO<PrdSystemPermissionFieldObjRoleFunctionVO> pagingField(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        this.checkPagingField(query);
        PagingVO<PrdSystemPermissionFieldObjRoleFunctionVO> objectPagingVO = this.dao.queryObjectByRoleId(query);
        List<PrdSystemPermissionFieldObjRoleFunctionVO> functionList = this.dao.queryFunctionByRoleId(query);
        List<PrdSystemPermissionFieldObjRoleFunctionVO> functionObjectList = this.dao.queryFunctionObjectByFunctionIds(functionList.stream().map(PrdSystemPermissionFieldObjRoleFunctionVO::getFunctionId).collect(Collectors.toList()));
        List<PrdSystemPermissionFieldObjRoleFunctionVO> functionObjectFieldList = this.dao.queryFunctionObjectFieldByFunctionObjectIds(functionObjectList.stream().map(PrdSystemPermissionFieldObjRoleFunctionVO::getFunctionObjectId).collect(Collectors.toList()));
        List<PrdSystemPermissionFieldObjRoleFunctionVO> fieldRuleList = this.dao.queryFieldRuleByRoleId(query);
        List records = objectPagingVO.getRecords();
        for (PrdSystemPermissionFieldObjRoleFunctionVO record : records) {
            ArrayList<PrdSystemPermissionFieldObjRoleFunctionVO> pc = new ArrayList<PrdSystemPermissionFieldObjRoleFunctionVO>();
            ArrayList<PrdSystemPermissionFieldObjRoleFunctionVO> app = new ArrayList<PrdSystemPermissionFieldObjRoleFunctionVO>();
            for (PrdSystemPermissionFieldObjRoleFunctionVO functionObjectVO : functionObjectList) {
                if (!record.getObjectId().equals(functionObjectVO.getObjectId())) continue;
                if ("PC".equals(functionObjectVO.getClientType())) {
                    this.assemblyData(functionObjectFieldList, fieldRuleList, functionObjectVO);
                    pc.add(functionObjectVO);
                } else {
                    this.assemblyData(functionObjectFieldList, fieldRuleList, functionObjectVO);
                    app.add(functionObjectVO);
                }
                functionObjectVO.setUuId(UUID.randomUUID().toString().trim().replaceAll(REPLACE_STR, REPLACE_MENT));
            }
            record.setUuId(UUID.randomUUID().toString().trim().replaceAll(REPLACE_STR, REPLACE_MENT));
            record.setApp(app);
            record.setPc(pc);
        }
        return objectPagingVO;
    }

    private void assemblyData(List<PrdSystemPermissionFieldObjRoleFunctionVO> functionObjectFieldList, List<PrdSystemPermissionFieldObjRoleFunctionVO> fieldRuleList, PrdSystemPermissionFieldObjRoleFunctionVO functionObjectVO) {
        ArrayList<PrdSystemPermissionFieldObjRoleFunctionVO> field = new ArrayList<PrdSystemPermissionFieldObjRoleFunctionVO>();
        for (PrdSystemPermissionFieldObjRoleFunctionVO fieldVO : functionObjectFieldList) {
            if (!fieldVO.getFunctionObjectId().equals(functionObjectVO.getFunctionObjectId())) continue;
            int size = field.size();
            for (PrdSystemPermissionFieldObjRoleFunctionVO fieldRuleVO : fieldRuleList) {
                if (!fieldRuleVO.getFieldId().equals(fieldVO.getFieldId())) continue;
                fieldVO.setRoleObjFunctionFieldId(fieldRuleVO.getRoleObjFunctionFieldId());
                fieldVO.setIsVisible(fieldRuleVO.getIsVisible());
                fieldVO.setIsEdit(fieldRuleVO.getIsEdit());
                field.add(fieldVO);
                break;
            }
            if (size == field.size()) {
                fieldVO.setIsEdit(Integer.valueOf(1));
                fieldVO.setIsVisible(Integer.valueOf(0));
                field.add(fieldVO);
            }
            fieldVO.setUuId(UUID.randomUUID().toString().trim().replaceAll(REPLACE_STR, REPLACE_MENT));
        }
        functionObjectVO.setField(field);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateField(List<PrdSystemPermissionFieldObjRoleFunctionPayload> payloads) {
        HashSet<Long> functionObjectSet = new HashSet<Long>();
        HashSet<Long> objectSet = new HashSet<Long>();
        ArrayList<PrdSystemPermissionFieldObjRoleFunctionDO> saveAll = new ArrayList<PrdSystemPermissionFieldObjRoleFunctionDO>();
        for (PrdSystemPermissionFieldObjRoleFunctionPayload payload : payloads) {
            PrdSystemPermissionFieldObjRoleFunctionDO entity;
            PrdSystemPermissionFieldObjRoleFunctionDO prdSystemPermissionFieldObjRoleFunctionDO = entity = ObjectUtils.isEmpty((Object)payload.getId()) ? this.insertEntity(payload) : this.updateEntity(payload);
            if (!functionObjectSet.contains(entity.getFunctionObjectId())) {
                functionObjectSet.add(entity.getFunctionObjectId());
            }
            saveAll.add(entity);
        }
        this.fieldObjRoleFunctionRepo.saveAll(saveAll);
        List allById = this.functionObjectRepo.findAllById(functionObjectSet);
        for (PrdSystemPermissionFunctionObjectDO functionObjectDO : allById) {
            if (objectSet.contains(functionObjectDO.getObjectId())) continue;
            PrdSystemBusinessObjectDO objectDO = this.businessObjectRepo.findById(functionObjectDO.getObjectId()).orElseGet(PrdSystemBusinessObjectDO::new);
            this.removeFieldRuleCache(objectDO.getObjectCode());
            objectSet.add(functionObjectDO.getObjectId());
        }
    }

    private PrdSystemPermissionFieldObjRoleFunctionDO insertEntity(PrdSystemPermissionFieldObjRoleFunctionPayload payload) {
        this.checkInsertEntity(payload);
        PrdSystemPermissionFieldObjRoleFunctionDO entityDO = PrdSystemPermissionFieldObjRoleFunctionConvert.INSTANCE.toDo(payload);
        return entityDO;
    }

    private void checkInsertEntity(PrdSystemPermissionFieldObjRoleFunctionPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getRoleId())) {
            throw TwException.error(REPLACE_MENT, "roleId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getFieldId())) {
            throw TwException.error(REPLACE_MENT, "field\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getFunctionObjectId())) {
            throw TwException.error(REPLACE_MENT, "functionObjectId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private PrdSystemPermissionFieldObjRoleFunctionDO updateEntity(PrdSystemPermissionFieldObjRoleFunctionPayload payload) {
        PrdSystemPermissionFieldObjRoleFunctionDO entity = this.fieldObjRoleFunctionRepo.findById(payload.getId()).orElseGet(PrdSystemPermissionFieldObjRoleFunctionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemPermissionFieldObjRoleFunctionDO entityDO = PrdSystemPermissionFieldObjRoleFunctionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDO);
        return entity;
    }

    public List<PrdSystemRoleVO> differentList(PrdSystemRoleQuery query) {
        return this.dao.differentList(query);
    }

    private void checkPagingField(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getRoleId())) {
            throw TwException.error(REPLACE_MENT, "roleId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkPagingFunctionList(PrdSystemRoleFunctionQuery query) {
        if (query.getRoleId() == null) {
            throw TwException.error(REPLACE_MENT, "roleId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkPagingUserList(PrdSystemRoleFunctionQuery query) {
        if (query.getRoleId() == null) {
            throw TwException.error(REPLACE_MENT, "roleId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void removeFieldRuleCache(String objectCode) {
        String redisKey = FIELD_RULE_CACHE_PREFIX + objectCode;
        if (this.redisUtils.hasKey(redisKey)) {
            this.redisUtils.del(redisKey);
        }
    }

    private void initialField(PrdSystemRolePayload payload) {
        List<PrdSystemPermissionFieldVO> tempFieldList;
        List functionObjectDOS = this.functionObjectService.queryByFunctionId(payload.getFunctionIds());
        Set functionObjectIds = functionObjectDOS.stream().map(BaseViewModel::getId).collect(Collectors.toSet());
        List fieldVOS = this.fieldService.queryByFunctionObjectIds(functionObjectIds);
        if (CollectionUtils.isEmpty((Collection)fieldVOS)) {
            return;
        }
        HashMap fieldMap = new HashMap();
        for (PrdSystemPermissionFieldVO fieldVO : fieldVOS) {
            String functionObjectId = String.valueOf(fieldVO.getFunctionObjectId());
            if (!fieldMap.containsKey(functionObjectId)) {
                tempFieldList = new ArrayList<PrdSystemPermissionFieldVO>();
                tempFieldList.add(fieldVO);
                fieldMap.put(functionObjectId, tempFieldList);
                continue;
            }
            tempFieldList = (List)fieldMap.get(functionObjectId);
            tempFieldList.add(fieldVO);
        }
        List fieldList = this.fieldObjRoleFunctionService.queryByRoleIdAndFunctionIds(payload.getId(), functionObjectIds);
        HashSet<Long> fieldSet = new HashSet<Long>(fieldList);
        ArrayList<PrdSystemPermissionFieldObjRoleFunctionDO> fieldObjRoleFunctionDOList = new ArrayList<PrdSystemPermissionFieldObjRoleFunctionDO>();
        for (PrdSystemPermissionFunctionObjectVO functionObjectDO : functionObjectDOS) {
            Long id = functionObjectDO.getId();
            tempFieldList = (List)fieldMap.get(String.valueOf(id));
            if (CollectionUtils.isEmpty(tempFieldList)) continue;
            for (PrdSystemPermissionFieldVO fieldVO : tempFieldList) {
                if (!fieldSet.add(fieldVO.getId())) continue;
                PrdSystemPermissionFieldObjRoleFunctionDO fieldObjRoleFunctionDO = new PrdSystemPermissionFieldObjRoleFunctionDO();
                fieldObjRoleFunctionDO.setFieldId(fieldVO.getId());
                fieldObjRoleFunctionDO.setRoleId(payload.getId());
                fieldObjRoleFunctionDO.setFunctionObjectId(id);
                fieldObjRoleFunctionDO.setIsVisible(0);
                fieldObjRoleFunctionDO.setIsEdit(1);
                fieldObjRoleFunctionDOList.add(fieldObjRoleFunctionDO);
            }
        }
        this.fieldObjRoleFunctionRepo.saveAll(fieldObjRoleFunctionDOList);
    }

    public Map<String, List<Long>> queryUserIdMapByRoleCodes(List<String> roleCodes) {
        return this.dao.queryUserIdMapByRoleCodes(roleCodes);
    }

    public List<Long> queryUserIdByRoleCodes(List<String> roleCodeList) {
        return this.dao.queryUserIdByRoleCodes(roleCodeList);
    }

    public void addUserMenu(List<Long> userList, String roleCode) {
        PrdSystemRoleVO prdSystemRoleVO = this.dao.queryByCode(roleCode);
        List<PrdOrgEmployeeRefVO> userDatas = this.dao.queryUsers(prdSystemRoleVO.getId());
        List oldUsers = userDatas.stream().map(e -> e.getUserId()).collect(Collectors.toList());
        List mergedList = Stream.concat(oldUsers.stream(), userList.stream()).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(mergedList)) {
            ArrayList<PrdSystemUserRoleDO> userDOS = new ArrayList<PrdSystemUserRoleDO>();
            for (Long userId : mergedList) {
                PrdSystemUserRoleDO userDO = new PrdSystemUserRoleDO();
                userDO.setUserId(userId);
                userDO.setRoleId(prdSystemRoleVO.getId());
                userDOS.add(userDO);
            }
            this.dao.deleteRolesByUserId(prdSystemRoleVO.getId());
            this.dao.saveUserRoleAll(userDOS);
        } else {
            this.dao.deleteRolesByUserId(prdSystemRoleVO.getId());
        }
    }

    public PrdSystemRoleServiceImpl(PrdSystemRoleDAO dao, PrdSystemPermissionFunctionObjectRepo functionObjectRepo, PrdSystemPermissionFunctionObjectService functionObjectService, PrdSystemPermissionFieldObjRoleFunctionRepo fieldObjRoleFunctionRepo, PrdSystemPermissionFieldObjRoleFunctionService fieldObjRoleFunctionService, PrdSystemBusinessObjectRepo businessObjectRepo, PrdSystemPermissionFieldService fieldService, RedisUtils redisUtils) {
        this.dao = dao;
        this.functionObjectRepo = functionObjectRepo;
        this.functionObjectService = functionObjectService;
        this.fieldObjRoleFunctionRepo = fieldObjRoleFunctionRepo;
        this.fieldObjRoleFunctionService = fieldObjRoleFunctionService;
        this.businessObjectRepo = businessObjectRepo;
        this.fieldService = fieldService;
        this.redisUtils = redisUtils;
    }
}

