/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActActivityConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/MARKET_ACTIVITY_C/callBack"})
@Transactional
public class MarketActivityCWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityCWorkflowCallBackController.class);
    private final CrmActActivityService actActivityService;
    private final CrmActActivityDAO actActivityDAO;
    private final PrdSystemBusinessChangeService changeService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        CrmActActivityPayload activityPayload = new CrmActActivityPayload();
        activityPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        CrmActActivityVO crmActActivityVO = this.actActivityService.queryByKey(Long.valueOf(businessKey));
        if (crmActActivityVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    activityPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    this.actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
                    break;
                }
                case INTERRUPT: 
                case INVALID: {
                    activityPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    this.changeService.deleteCurrentVersionLog(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), crmActActivityVO.getId().toString());
                    this.actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
                    break;
                }
                case REJECTED: {
                    activityPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    this.actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
                    break;
                }
                case APPROVED: {
                    activityPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    activityPayload.setApprovedTime(LocalDateTime.now());
                    this.actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
                    Map stringObjectMap = this.changeService.activeCurrentVersionLog(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), crmActActivityVO.getId().toString());
                    CrmActActivityVO newActivity = (CrmActActivityVO)JSON.parseObject((String)stringObjectMap.toString(), CrmActActivityVO.class);
                    CrmActActivityPayload newActivityPayload = CrmActActivityConvert.INSTANCE.toPayload(newActivity);
                    newActivityPayload.setDoSave(Boolean.valueOf(true));
                    this.actActivityService.update(newActivityPayload);
                    break;
                }
                case APPROVING: {
                    activityPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    activityPayload.setProjectStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.actActivityDAO.updateActivityByKeyDynamic(activityPayload);
        }
        return WorkflowResult.success(null);
    }

    public MarketActivityCWorkflowCallBackController(CrmActActivityService actActivityService, CrmActActivityDAO actActivityDAO, PrdSystemBusinessChangeService changeService) {
        this.actActivityService = actActivityService;
        this.actActivityDAO = actActivityDAO;
        this.changeService = changeService;
    }
}

