package com.elitesland.tw.tw5.server.common.permission.core;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.lang.annotation.Annotation;
import java.util.Map;

/**
 * @Author Quruiqizz
 * @Date 2023/12/22 14:51
 **/
@Component
public class ApplicationContextHolder implements ApplicationContextAware {

    private static ApplicationContext CONTEXT;

    /**
     * 注入applicationContext  可以自定义获取 Bean的方式
     *
     * @param applicationContext
     * @throws BeansException
     */
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextHolder.CONTEXT = applicationContext;
    }

    /**
     * 获取bean 关于注解
     *
     * @param annotationType
     * @return
     */
    public Map<String, Object> getBeansByAnnotation(Class<? extends Annotation> annotationType) {
        return CONTEXT.getBeansWithAnnotation(annotationType);
    }

    /**
     * 根据类型获取bean信息
     *
     * @param requiredType
     * @param <T>
     * @return
     */
    public  <T> T getBean(Class<T> requiredType) {
        return CONTEXT.getBean(requiredType);
    }

    /**
     * 获取 容器上下文实例
     *
     * @return
     */
    public static ApplicationContext getInstance() {
        return CONTEXT;
    }

}
