package com.elitesland.tw.tw5.server.common.permission.strategy.context;

import com.elitesland.tw.tw5.server.common.permission.strategy.RoleStrategyService;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @Author Quruiqizz
 * @Date 2023/11/10 10:49
 **/
@Component
public class RoleStrategyContext {

    private final Map<String, RoleStrategyService> roleStrategyMap = new ConcurrentHashMap<>();

    /**
     * 通过构造器注入的方式 拿到策略下的策略实现类
     *
     * @param strategyMap
     */
    public RoleStrategyContext(Map<String, RoleStrategyService> strategyMap) {

        roleStrategyMap.clear();
        roleStrategyMap.putAll(strategyMap);

    }

    /**
     * 获取对应策略下可以使用的bean
     *
     * @param beanName
     * @return
     */
    public RoleStrategyService getStrategyBean(String beanName) {
        return roleStrategyMap.get(beanName);
    }

    /**
     * 获取对应策略下可以使用的bean
     *
     * @param beanName1
     * @param beanName2
     * @return
     */
    public RoleStrategyService getStrategyBean(String beanName1, String beanName2) {
        RoleStrategyService strategyBean = getStrategyBean(beanName1);
        if (!ObjectUtils.isEmpty(strategyBean)) {
            return strategyBean;
        }

        return getStrategyBean(beanName2);
    }

}
