package com.elitesland.tw.tw5.server.prd.acc.controller;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingOverduePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingOverdueService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingContinuousVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

/**
 * 报销逾期配置
 *
 * @author zoey
 * @date 2024-04-08
 */
@Api(tags = "报销逾期配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/accReimSettingOverdue")
@Slf4j
public class AccReimSettingOverdueController {

private final AccReimSettingOverdueService accReimSettingOverdueService;

    /**
     * 报销逾期配置-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销逾期配置-新增")
    public TwOutputUtil<AccReimSettingOverdueVO> insert(@RequestBody AccReimSettingOverduePayload payload){
         return TwOutputUtil.ok(accReimSettingOverdueService.insert(payload));
    }

    /**
     * 报销逾期配置-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销逾期配置-更新")
    public TwOutputUtil<AccReimSettingOverdueVO> update(@RequestBody AccReimSettingOverduePayload payload){
        return TwOutputUtil.ok(accReimSettingOverdueService.update(payload));
    }

    /**
     * 报销逾期配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销逾期配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimSettingOverduePayload payload){
        return TwOutputUtil.ok(accReimSettingOverdueService.updateByKeyDynamic(payload));
    }

    /**
     * 报销逾期配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销逾期配置-主键查询")
    public TwOutputUtil<AccReimSettingOverdueVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimSettingOverdueService.queryByKey(key));
    }

    /**
     * 报销逾期配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("报销逾期配置-分页")
    public TwOutputUtil<PagingVO<AccReimSettingOverdueVO>> paging(AccReimSettingOverdueQuery query) {
        return TwOutputUtil.ok(accReimSettingOverdueService.queryPaging(query));
    }

    /**
     * 报销逾期配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("报销逾期配置-查询列表")
    public TwOutputUtil<List<AccReimSettingOverdueVO>> queryList(AccReimSettingOverdueQuery query) {
        return TwOutputUtil.ok(accReimSettingOverdueService.queryListDynamic(query));
    }

    /**
     * 报销逾期配置-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销逾期配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         accReimSettingOverdueService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 报销配置逾期规则配置-规则检查
     *
     * @param key 有效载荷
     * @param invoiceNo 有效载荷
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/ruleCheck/{key}")
    @ApiOperation("报销配置逾期规则配置-规则检查")
    public TwOutputUtil<AccReimSettingOverdueVO> ruleCheck(@PathVariable Long key, String expenseDate, String invoiceNo,Long reimUserId){
        return TwOutputUtil.ok(accReimSettingOverdueService.ruleCheck(key,expenseDate,invoiceNo,reimUserId));
    }


}

