package com.elitesland.tw.tw5.server.prd.acc.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimRulePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimRuleQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimRuleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimRuleDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimRuleDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimRuleRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 报销规则管理
 *
 * @author sunxw
 * @date 2023-12-03
 */
@Repository
@RequiredArgsConstructor
public class AccReimRuleDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccReimRuleRepo repo;
    private final QAccReimRuleDO qdo = QAccReimRuleDO.accReimRuleDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimRuleVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccReimRuleVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 规则编号
                qdo.ruleNo,
                // 规则名称
                qdo.ruleName,
                // 核算项目(对多个生效时，可以,分割)
                qdo.busAccItemCodes,
                // 费用发生日期
                qdo.expenseDate,
                // 发票日期
                qdo.invDate,
                // 额度控制
                qdo.limitAmt,
                // 规则类型 NORMAL-通用  ACC_TRIP-差旅 等(与单据类型一致)
                qdo.ruleType,
                // 检查范围 ALL-当前报销单所有明细 SELF-仅自己/单条
                qdo.checkRange,
                // 是否支持动态配置 0-否 1-是
                qdo.dynamicFlag,
                // 规则开关标识 0-关闭 1-开启 
                qdo.ruleFlag,
                // 规则提示信息
                qdo.noticeMsg,
                // 规则提示登记 WARN-存在警告 ILLEGAL-不符合规范
                qdo.noticeLevel,
                // 扩展字段1 作为出发地
                qdo.extString1,
                // 扩展字段2 作为目的地
                qdo.extString2,
                // 扩展字段3 作为日期起
                qdo.extString3,
                // 扩展字段4 作为日期止
                qdo.extString4,
                // 扩展字段5
                qdo.extString5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimRuleVO> getJpaQueryWhere(AccReimRuleQuery query) {
        JPAQuery<AccReimRuleVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccReimRuleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccReimRuleQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 规则编号 精确 */
        if (!ObjectUtils.isEmpty(query.getRuleNo())) {
            list.add(qdo.ruleNo.eq(query.getRuleNo()));
        }
        /** 规则名称 精确 */
        if (!ObjectUtils.isEmpty(query.getRuleName())) {
            list.add(qdo.ruleName.eq(query.getRuleName()));
        }
        /** 核算项目(对多个生效时，可以,分割) 精确 */
        if (!ObjectUtils.isEmpty(query.getBusAccItemCodes())) {
            list.add(qdo.busAccItemCodes.eq(query.getBusAccItemCodes()));
        }
        /** 费用发生日期 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseDate())) {
            list.add(qdo.expenseDate.eq(query.getExpenseDate()));
        }
        /** 发票日期 精确 */
        if (!ObjectUtils.isEmpty(query.getInvDate())) {
            list.add(qdo.invDate.eq(query.getInvDate()));
        }
        /** 额度控制 精确 */
        if (!ObjectUtils.isEmpty(query.getLimitAmt())) {
            list.add(qdo.limitAmt.eq(query.getLimitAmt()));
        }
        /** 规则类型 NORMAL-通用  ACC_TRIP-差旅 等(与单据类型一致) 精确 */
        if (!ObjectUtils.isEmpty(query.getRuleType())) {
            list.add(qdo.ruleType.eq(query.getRuleType()));
        }
        //规则类型(多个)
        if (!ObjectUtils.isEmpty(query.getRuleTypeList())) {
            list.add(qdo.ruleType.in(query.getRuleTypeList()));
        }
        /** 检查范围 ALL-当前报销单所有明细 SELF-仅自己/单条 精确 */
        if (!ObjectUtils.isEmpty(query.getCheckRange())) {
            list.add(qdo.checkRange.eq(query.getCheckRange()));
        }
        /** 是否支持动态配置 0-否 1-是 精确 */
        if (!ObjectUtils.isEmpty(query.getDynamicFlag())) {
            list.add(qdo.dynamicFlag.eq(query.getDynamicFlag()));
        }
        /** 规则开关标识 0-关闭 1-开启  精确 */
        if (!ObjectUtils.isEmpty(query.getRuleFlag())) {
            list.add(qdo.ruleFlag.eq(query.getRuleFlag()));
        }
        /** 规则提示信息 精确 */
        if (!ObjectUtils.isEmpty(query.getNoticeMsg())) {
            list.add(qdo.noticeMsg.eq(query.getNoticeMsg()));
        }
        /** 规则提示登记 WARN-存在警告 ILLEGAL-不符合规范 精确 */
        if (!ObjectUtils.isEmpty(query.getNoticeLevel())) {
            list.add(qdo.noticeLevel.eq(query.getNoticeLevel()));
        }
        /** 扩展字段1 作为出发地 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            list.add(qdo.extString1.eq(query.getExtString1()));
        }
        /** 扩展字段2 作为目的地 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            list.add(qdo.extString2.eq(query.getExtString2()));
        }
        /** 扩展字段3 作为日期起 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString3())) {
            list.add(qdo.extString3.eq(query.getExtString3()));
        }
        /** 扩展字段4 作为日期止 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString4())) {
            list.add(qdo.extString4.eq(query.getExtString4()));
        }
        /** 扩展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            list.add(qdo.extString5.eq(query.getExtString5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccReimRuleVO queryByKey(Long id) {
        JPAQuery<AccReimRuleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccReimRuleVO> queryListDynamic(AccReimRuleQuery query) {
        JPAQuery<AccReimRuleVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccReimRuleVO> queryPaging(AccReimRuleQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AccReimRuleVO> jpaQuery = getJpaQueryWhere(query);
        List<AccReimRuleVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccReimRuleVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccReimRuleDO save(AccReimRuleDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccReimRuleDO> saveAll(List<AccReimRuleDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccReimRulePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 规则编号
        if (payload.getRuleNo() != null) {
            update.set(qdo.ruleNo, payload.getRuleNo());
        }
        // 规则名称
        if (payload.getRuleName() != null) {
            update.set(qdo.ruleName, payload.getRuleName());
        }
        // 核算项目(对多个生效时，可以,分割)
        if (payload.getBusAccItemCodes() != null) {
            update.set(qdo.busAccItemCodes, payload.getBusAccItemCodes());
        }
        // 费用发生日期
        if (payload.getExpenseDate() != null) {
            update.set(qdo.expenseDate, payload.getExpenseDate());
        }
        // 发票日期
        if (payload.getInvDate() != null) {
            update.set(qdo.invDate, payload.getInvDate());
        }
        // 额度控制
        if (payload.getLimitAmt() != null) {
            update.set(qdo.limitAmt, payload.getLimitAmt());
        }
        // 规则类型 NORMAL-通用  ACC_TRIP-差旅 等(与单据类型一致)
        if (payload.getRuleType() != null) {
            update.set(qdo.ruleType, payload.getRuleType());
        }
        // 检查范围 ALL-当前报销单所有明细 SELF-仅自己/单条
        if (payload.getCheckRange() != null) {
            update.set(qdo.checkRange, payload.getCheckRange());
        }
        // 是否支持动态配置 0-否 1-是
        if (payload.getDynamicFlag() != null) {
            update.set(qdo.dynamicFlag, payload.getDynamicFlag());
        }
        // 规则开关标识 0-关闭 1-开启 
        if (payload.getRuleFlag() != null) {
            update.set(qdo.ruleFlag, payload.getRuleFlag());
        }
        // 规则提示信息
        if (payload.getNoticeMsg() != null) {
            update.set(qdo.noticeMsg, payload.getNoticeMsg());
        }
        // 规则提示登记 WARN-存在警告 ILLEGAL-不符合规范
        if (payload.getNoticeLevel() != null) {
            update.set(qdo.noticeLevel, payload.getNoticeLevel());
        }
        // 扩展字段1 作为出发地
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        // 扩展字段2 作为目的地
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        // 扩展字段3 作为日期起
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        // 扩展字段4 作为日期止
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        // 扩展字段5
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 规则编号
            if (nullFields.contains("ruleNo")) {
                update.setNull(qdo.ruleNo);
            }
            // 规则名称
            if (nullFields.contains("ruleName")) {
                update.setNull(qdo.ruleName);
            }
            // 核算项目(对多个生效时，可以,分割)
            if (nullFields.contains("busAccItemCodes")) {
                update.setNull(qdo.busAccItemCodes);
            }
            // 费用发生日期
            if (nullFields.contains("expenseDate")) {
                update.setNull(qdo.expenseDate);
            }
            // 发票日期
            if (nullFields.contains("invDate")) {
                update.setNull(qdo.invDate);
            }
            // 额度控制
            if (nullFields.contains("limitAmt")) {
                update.setNull(qdo.limitAmt);
            }
            // 规则类型 NORMAL-通用  ACC_TRIP-差旅 等(与单据类型一致)
            if (nullFields.contains("ruleType")) {
                update.setNull(qdo.ruleType);
            }
            // 检查范围 ALL-当前报销单所有明细 SELF-仅自己/单条
            if (nullFields.contains("checkRange")) {
                update.setNull(qdo.checkRange);
            }
            // 是否支持动态配置 0-否 1-是
            if (nullFields.contains("dynamicFlag")) {
                update.setNull(qdo.dynamicFlag);
            }
            // 规则开关标识 0-关闭 1-开启 
            if (nullFields.contains("ruleFlag")) {
                update.setNull(qdo.ruleFlag);
            }
            // 规则提示信息
            if (nullFields.contains("noticeMsg")) {
                update.setNull(qdo.noticeMsg);
            }
            // 规则提示登记 WARN-存在警告 ILLEGAL-不符合规范
            if (nullFields.contains("noticeLevel")) {
                update.setNull(qdo.noticeLevel);
            }
            // 扩展字段1 作为出发地
            if (nullFields.contains("extString1")) {
                update.setNull(qdo.extString1);
            }
            // 扩展字段2 作为目的地
            if (nullFields.contains("extString2")) {
                update.setNull(qdo.extString2);
            }
            // 扩展字段3 作为日期起
            if (nullFields.contains("extString3")) {
                update.setNull(qdo.extString3);
            }
            // 扩展字段4 作为日期止
            if (nullFields.contains("extString4")) {
                update.setNull(qdo.extString4);
            }
            // 扩展字段5
            if (nullFields.contains("extString5")) {
                update.setNull(qdo.extString5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

