package com.elitesland.tw.tw5.server.prd.acc.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplatePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccSubjectTemplateDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccSubjectTemplateDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccSubjectTemplateRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 科目模板管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Repository
@RequiredArgsConstructor
public class AccSubjectTemplateDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccSubjectTemplateRepo repo;
    private final QAccSubjectTemplateDO qdo = QAccSubjectTemplateDO.accSubjectTemplateDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccSubjectTemplateVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccSubjectTemplateVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 模板编号
                qdo.tmplNo,
                // 模板名称
                qdo.tmplName,
                // 适用行业
                qdo.tmplIndustry,
                // 模板状态
                qdo.tmplStatus,
                // 模板类别
                qdo.tmplClass,
                // 适用类型
                qdo.tmplType,
                // 预算控制级别
                qdo.budgetLevel,
                // 控制策略
                qdo.controlType,
                // 可配置字段1
                qdo.extStr1,
                // 可配置字段2
                qdo.extStr2,
                // 可配置字段3
                qdo.extStr3,
                // 可配置字段4
                qdo.extStr4,
                // 可配置字段5
                qdo.extStr5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccSubjectTemplateVO> getJpaQueryWhere(AccSubjectTemplateQuery query) {
        JPAQuery<AccSubjectTemplateVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccSubjectTemplateQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccSubjectTemplateQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一id 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        if (!ObjectUtils.isEmpty(query.getInIds())) {
            list.add(qdo.id.in(query.getInIds()));
        }
        /** 模板编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getTmplNo())) {
            list.add(qdo.tmplNo.like(SqlUtil.toSqlLikeString(query.getTmplNo())));
        }
        /** 模板名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getTmplName())) {
            list.add(qdo.tmplName.like(SqlUtil.toSqlLikeString(query.getTmplName())));
        }
        /** 适用行业 精确 */
        if (!ObjectUtils.isEmpty(query.getTmplIndustry())) {
            list.add(qdo.tmplIndustry.eq(query.getTmplIndustry()));
        }
        /** 模板状态 精确 */
        if (!ObjectUtils.isEmpty(query.getTmplStatus())) {
            list.add(qdo.tmplStatus.eq(query.getTmplStatus()));
        }
        /** 模板类别 精确 */
        if (!ObjectUtils.isEmpty(query.getTmplClass())) {
            list.add(qdo.tmplClass.eq(query.getTmplClass()));
        }
        /** 适用类型 模糊 */
        if (!ObjectUtils.isEmpty(query.getTmplType())) {
            list.add(qdo.tmplType.like(SqlUtil.toSqlLikeString(query.getTmplType())));
        }
        /** 预算控制级别 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetLevel())) {
            list.add(qdo.budgetLevel.eq(query.getBudgetLevel()));
        }
        /** 控制策略 精确 */
        if (!ObjectUtils.isEmpty(query.getControlType())) {
            list.add(qdo.controlType.eq(query.getControlType()));
        }
        /** 可配置字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr1())) {
            list.add(qdo.extStr1.eq(query.getExtStr1()));
        }
        /** 可配置字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr2())) {
            list.add(qdo.extStr2.eq(query.getExtStr2()));
        }
        /** 可配置字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr3())) {
            list.add(qdo.extStr3.eq(query.getExtStr3()));
        }
        /** 可配置字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr4())) {
            list.add(qdo.extStr4.eq(query.getExtStr4()));
        }
        /** 可配置字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr5())) {
            list.add(qdo.extStr5.eq(query.getExtStr5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccSubjectTemplateVO queryByKey(Long id) {
        JPAQuery<AccSubjectTemplateVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccSubjectTemplateVO> queryListDynamic(AccSubjectTemplateQuery query) {
        JPAQuery<AccSubjectTemplateVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccSubjectTemplateVO> queryPaging(AccSubjectTemplateQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AccSubjectTemplateVO> jpaQuery = getJpaQueryWhere(query);
        List<AccSubjectTemplateVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccSubjectTemplateVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccSubjectTemplateDO save(AccSubjectTemplateDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccSubjectTemplateDO> saveAll(List<AccSubjectTemplateDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccSubjectTemplatePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一id
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 模板编号
        if (payload.getTmplNo() != null) {
            update.set(qdo.tmplNo, payload.getTmplNo());
        }
        // 模板名称
        if (payload.getTmplName() != null) {
            update.set(qdo.tmplName, payload.getTmplName());
        }
        // 适用行业
        if (payload.getTmplIndustry() != null) {
            update.set(qdo.tmplIndustry, payload.getTmplIndustry());
        }
        // 模板状态
        if (payload.getTmplStatus() != null) {
            update.set(qdo.tmplStatus, payload.getTmplStatus());
        }
        // 模板类别
        if (payload.getTmplClass() != null) {
            update.set(qdo.tmplClass, payload.getTmplClass());
        }
        // 适用类型
        if (payload.getTmplType() != null) {
            update.set(qdo.tmplType, payload.getTmplType());
        }
        // 预算控制级别
        if (payload.getBudgetLevel() != null) {
            update.set(qdo.budgetLevel, payload.getBudgetLevel());
        }
        // 控制策略
        if (payload.getControlType() != null) {
            update.set(qdo.controlType, payload.getControlType());
        }
        // 可配置字段1
        if (payload.getExtStr1() != null) {
            update.set(qdo.extStr1, payload.getExtStr1());
        }
        // 可配置字段2
        if (payload.getExtStr2() != null) {
            update.set(qdo.extStr2, payload.getExtStr2());
        }
        // 可配置字段3
        if (payload.getExtStr3() != null) {
            update.set(qdo.extStr3, payload.getExtStr3());
        }
        // 可配置字段4
        if (payload.getExtStr4() != null) {
            update.set(qdo.extStr4, payload.getExtStr4());
        }
        // 可配置字段5
        if (payload.getExtStr5() != null) {
            update.set(qdo.extStr5, payload.getExtStr5());
        }
        // 备注
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一id
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 模板编号
            if (nullFields.contains("tmplNo")) {
                update.setNull(qdo.tmplNo);
            }
            // 模板名称
            if (nullFields.contains("tmplName")) {
                update.setNull(qdo.tmplName);
            }
            // 适用行业
            if (nullFields.contains("tmplIndustry")) {
                update.setNull(qdo.tmplIndustry);
            }
            // 模板状态
            if (nullFields.contains("tmplStatus")) {
                update.setNull(qdo.tmplStatus);
            }
            // 模板类别
            if (nullFields.contains("tmplClass")) {
                update.setNull(qdo.tmplClass);
            }
            // 适用类型
            if (nullFields.contains("tmplType")) {
                update.setNull(qdo.tmplType);
            }
            // 预算控制级别
            if (nullFields.contains("budgetLevel")) {
                update.setNull(qdo.budgetLevel);
            }
            // 控制策略
            if (nullFields.contains("controlType")) {
                update.setNull(qdo.controlType);
            }
            // 可配置字段1
            if (nullFields.contains("extStr1")) {
                update.setNull(qdo.extStr1);
            }
            // 可配置字段2
            if (nullFields.contains("extStr2")) {
                update.setNull(qdo.extStr2);
            }
            // 可配置字段3
            if (nullFields.contains("extStr3")) {
                update.setNull(qdo.extStr3);
            }
            // 可配置字段4
            if (nullFields.contains("extStr4")) {
                update.setNull(qdo.extStr4);
            }
            // 可配置字段5
            if (nullFields.contains("extStr5")) {
                update.setNull(qdo.extStr5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据名称查询
     *
     * @param tmplName
     * @return
     */
    public List<Long> queryByName(String tmplName) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.id).from(qdo).where(qdo.deleteFlag.eq(0)).
                where(qdo.tmplName.eq(tmplName));
        return jpaQuery.fetch();
    }

    /**
     * 修改模板状态
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long updateStatus(List<Long> keys, String status) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.tmplStatus, status)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}

