package com.elitesland.tw.tw5.server.prd.acc.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayBatchPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimPayBatchQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimPayBatchService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimPayBatchVO;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimPayBatchConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimPayBatchDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimPayBatchDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimPayBatchRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 费用报销记账/付款导出管理
 *
 * @author sunxw
 * @date 2023-12-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimPayBatchServiceImpl extends BaseServiceImpl implements AccReimPayBatchService {

    private final AccReimPayBatchRepo accReimPayBatchRepo;
    private final AccReimPayBatchDAO accReimPayBatchDAO;

    @Override
    public PagingVO<AccReimPayBatchVO> queryPaging(AccReimPayBatchQuery query) {
        return accReimPayBatchDAO.queryPaging(query);
    }

    @Override
    public List<AccReimPayBatchVO> queryListDynamic(AccReimPayBatchQuery query) {
        return accReimPayBatchDAO.queryListDynamic(query);
    }

    @Override
    public AccReimPayBatchVO queryByKey(Long key) {
        return accReimPayBatchDAO.queryByKey(key);
    }

    @Override
    @Transactional
    public AccReimPayBatchVO insert(AccReimPayBatchPayload payload) {
        AccReimPayBatchDO entityDo = AccReimPayBatchConvert.INSTANCE.toDo(payload);
        return AccReimPayBatchConvert.INSTANCE.toVo(accReimPayBatchRepo.save(entityDo));
    }

    @Override
    @Transactional
    public AccReimPayBatchVO update(AccReimPayBatchPayload payload) {
        AccReimPayBatchDO entity = accReimPayBatchRepo.findById(payload.getId()).orElseGet(AccReimPayBatchDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimPayBatchDO entityDo = AccReimPayBatchConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimPayBatchConvert.INSTANCE.toVo(accReimPayBatchRepo.save(entity));
    }

    @Override
    @Transactional
    public long updateByKeyDynamic(AccReimPayBatchPayload payload) {
//        AccReimPayBatchDO entity = accReimPayBatchRepo.findById(payload.getId()).orElseGet(AccReimPayBatchDO::new);
//        Assert.notNull(entity.getId(), "不存在");
        long result = accReimPayBatchDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            accReimPayBatchDAO.deleteSoft(keys);
        }
    }

}
