package com.elitesland.tw.tw5.server.prd.acc.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingLimitRulePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingLimitRuleQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingLimitRuleService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingLimitRuleVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimSettingTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingLimitRuleConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingLimitRuleDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingLimitRuleDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingLimitRuleRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 报销额度配置
 *
 * @author zoey
 * @date 2024-05-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimSettingLimitRuleServiceImpl extends BaseServiceImpl implements AccReimSettingLimitRuleService {

    private final AccReimSettingLimitRuleRepo AccReimSettingLimitRuleRepo;
    private final AccReimSettingLimitRuleDAO AccReimSettingLimitRuleDAO;
    private final AccReimSettingService accReimSettingService;
    private final AccReimSettingRepo accReimSettingRepo;

    @Override
    public PagingVO<AccReimSettingLimitRuleVO> queryPaging(AccReimSettingLimitRuleQuery query){
        return AccReimSettingLimitRuleDAO.queryPaging(query);
    }

    @Override
    public List<AccReimSettingLimitRuleVO> queryListDynamic(AccReimSettingLimitRuleQuery query){
        return AccReimSettingLimitRuleDAO.queryListDynamic(query);
    }

    @Override
    public AccReimSettingLimitRuleVO queryByKey(Long key) {
        AccReimSettingLimitRuleDO entity = AccReimSettingLimitRuleRepo.findById(key).orElseGet(AccReimSettingLimitRuleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        return AccReimSettingLimitRuleConvert.INSTANCE.toVo(entity);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingLimitRuleVO insert(AccReimSettingLimitRulePayload payload) {
        // 保存当前配置表
        AccReimSettingLimitRuleDO entityDo = AccReimSettingLimitRuleConvert.INSTANCE.toDo(payload);
        AccReimSettingLimitRuleVO AccReimSettingLimitRuleVO = AccReimSettingLimitRuleConvert.INSTANCE.toVo(AccReimSettingLimitRuleRepo.save(entityDo));
        return AccReimSettingLimitRuleVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingLimitRuleVO update(AccReimSettingLimitRulePayload payload) {
        AccReimSettingLimitRuleDO entity = AccReimSettingLimitRuleRepo.findById(payload.getId()).orElseGet(AccReimSettingLimitRuleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingLimitRuleDO entityDo = AccReimSettingLimitRuleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        AccReimSettingLimitRuleVO AccReimSettingLimitRuleVO = AccReimSettingLimitRuleConvert.INSTANCE.toVo(AccReimSettingLimitRuleRepo.save(entity));
        return AccReimSettingLimitRuleVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AccReimSettingLimitRulePayload payload) {
        AccReimSettingLimitRuleDO entity = AccReimSettingLimitRuleRepo.findById(payload.getId()).orElseGet(AccReimSettingLimitRuleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = AccReimSettingLimitRuleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            AccReimSettingLimitRuleDAO.deleteSoft(keys);
        }
    }

}
