package com.elitesland.tw.tw5.server.prd.adm.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmFeeApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmFeeApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 特殊费用申请管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Api(tags = "特殊费用申请管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/adm/admFeeApply")
@Slf4j
public class AdmFeeApplyController {

    private final AdmFeeApplyService admFeeApplyService;

    /**
     * 特殊费用申请管理-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("特殊费用申请管理-新增或修改")
    public TwOutputUtil<AdmFeeApplyVO> insertOrUpdate(@RequestBody AdmFeeApplyPayload payload) {
        return TwOutputUtil.ok(admFeeApplyService.insertOrUpdate(payload));
    }

//    /**
//     * 特殊费用申请管理-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("特殊费用申请管理-更新")
//    public TwOutputUtil<AdmFeeApplyVO> update(@RequestBody AdmFeeApplyPayload payload) {
//        return TwOutputUtil.ok(admFeeApplyService.update(payload));
//    }
//
//    /**
//     * 特殊费用申请管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("特殊费用申请管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AdmFeeApplyPayload payload) {
//        return TwOutputUtil.ok(admFeeApplyService.updateByKeyDynamic(payload));
//    }

    /**
     * 特殊费用申请管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("特殊费用申请管理-主键查询")
    public TwOutputUtil<AdmFeeApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(admFeeApplyService.queryByKey(key));
    }

    /**
     * 特殊费用申请管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("特殊费用申请管理-分页")
    public TwOutputUtil<PagingVO<AdmFeeApplyVO>> paging(AdmFeeApplyQuery query) {
        return TwOutputUtil.ok(admFeeApplyService.queryPaging(query));
    }

    /**
     * 特殊费用申请管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("特殊费用申请管理-查询列表")
    public TwOutputUtil<List<AdmFeeApplyVO>> queryList(AdmFeeApplyQuery query) {
        return TwOutputUtil.ok(admFeeApplyService.queryListDynamic(query));
    }

    /**
     * 特殊费用申请管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("特殊费用申请管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        admFeeApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

