package com.elitesland.tw.tw5.server.prd.cal.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 当量结算定价管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Entity
@Table(name = "cal_settle_price", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "cal_settle_price", comment = "当量结算定价管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CalSettlePriceDO extends BaseModel implements Serializable {
    /**
     * from bu结算类型码
     */
    @Comment("from bu结算类型码")
    @Column()
    private String fromBuDealtype;
    /**
     * to bu结算类型码
     */
    @Comment("to bu结算类型码")
    @Column()
    private String toBuDealtype;
    /**
     * from bu_id
     */
    @Comment("from bu_id")
    @Column()
    private Long fromBuId;
    /**
     * to bu_id
     */
    @Comment("to bu_id")
    @Column()
    private Long toBuId;
    /**
     * 工种
     */
    @Comment("工种")
    @Column()
    private String jobType1;
    /**
     * 工种子类
     */
    @Comment("工种子类")
    @Column()
    private String jobType2;
    /**
     * 核算年度
     */
    @Comment("核算年度")
    @Column()
    private Integer finYear;
    /**
     * 核算期间
     */
    @Comment("核算期间")
    @Column()
    private Integer finPeriod;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projId;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column()
    private String projName;
    /**
     * 资源id
     */
    @Comment("资源id")
    @Column()
    private Long resId;
    /**
     * 定价策略（mark up百分比，mark up金额，绝对结算金额）
     */
    @Comment("定价策略（mark up百分比，mark up金额，绝对结算金额）")
    @Column()
    private String priceStrategy;
    /**
     * 调整价格（mark up百分比，mark up金额，绝对结算金额）
     */
    @Comment("调整价格（mark up百分比，mark up金额，绝对结算金额）")
    @Column()
    private BigDecimal markupPrice;

    public void copy(CalSettlePriceDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
