package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationSitesPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationSitesQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationSitesService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
* 客户经营-企业年报网址
*
* @author duwh
* @date 2022-12-05
*/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/crmCustomerOperationSites")
@Slf4j
public class CrmCustomerOperationSitesController {

    private final CrmCustomerOperationSitesService crmCustomerOperationSitesService;

    /**
    * 新增
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PostMapping
    public TwOutputUtil insert(@RequestBody CrmCustomerOperationSitesPayload payload){
        if (null == payload.getOperId()) {
            return TwOutputUtil.error("999", "operId参数缺失", payload);
        }
        return TwOutputUtil.ok(crmCustomerOperationSitesService.insert(payload));
    }

    /**
    * 更新
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PutMapping
    public TwOutputUtil update(@RequestBody CrmCustomerOperationSitesPayload payload){
        return TwOutputUtil.ok(crmCustomerOperationSitesService.update(payload));
    }

    /**
    * 主键查询
    *
    * @param key 关键
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(crmCustomerOperationSitesService.queryByKey(key));
    }

    /**
    * 分页
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(CrmCustomerOperationSitesQuery query) {
        if (null == query.getOperId()) {
            return TwOutputUtil.error("999", "operId参数缺失", null);
        }
        return TwOutputUtil.ok(crmCustomerOperationSitesService.paging(query));
    }

    /**
    * 查询列表
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(CrmCustomerOperationSitesQuery query) {
        if (null == query.getOperId()) {
            return TwOutputUtil.error("999", "operId参数缺失", null);
        }
        return TwOutputUtil.ok(crmCustomerOperationSitesService.queryList(query));
    }

    /**
    * 删除
    *
    * @param keys 主键id
    * @return result
    */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        crmCustomerOperationSitesService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
