package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeopleWorkPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleWorkQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleWorkService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleWorkVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 人脉-工作经历
 *
 * @author carl
 * @date 2022/12/07
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmPeopleWorkController {

    private final CrmPeopleWorkService service;

    /**
     * 新增或更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/peopleWork")
    public TwOutputUtil insertOrUpdate(CrmPeopleWorkPayload payload) {
        return TwOutputUtil.ok(service.insertOrUpdate(payload));
    }


    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/peopleWork/{key}")
    //@UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmPeopleWorkVO prdFileVO = service.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }


    /**
     * 查询列表
     *
     * @param peopleId 人脉id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/peopleWork/list")
    //@UdcNameClass
    public TwOutputUtil queryList(Long peopleId) {
        CrmPeopleWorkQuery query = new CrmPeopleWorkQuery();
        query.setPeopleId(peopleId);
        List<CrmPeopleWorkVO> vos = service.queryList(query);
        return TwOutputUtil.ok(vos);
    }


    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/peopleWork/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
