package com.elitesland.tw.tw5.server.prd.humanresources.personnel.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResEntryExitLogQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEntryExitLogService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResEntryExitLogVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "资源入离职记录管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/org")
@Slf4j
public class ResEntryExitLogController {

    private final ResEntryExitLogService service;

    /**
     * 入离职记录分页查询
     *
     * @param query 条件
     * @return result
     */
    @ApiOperation("入离职记录分页查询")
    @GetMapping("/res/exitEntryLog/paging")
    @UdcNameClass
    public TwOutputUtil<PagingVO<ResEntryExitLogVO>> queryPaging(ResEntryExitLogQuery query) {
        PagingVO<ResEntryExitLogVO> paging = service.queryPaging(query);
        return TwOutputUtil.ok(paging);
    }

}
