package com.elitesland.tw.tw5.server.prd.humanresources.resource.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Entity
@Table(name = "work_order_apply")
@org.hibernate.annotations.Table(appliesTo = "work_order_apply", comment = "派工单申请")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class WorkOrderApplyDO extends BaseModel {

    @Comment("派工单名称")
    @Column()
    private String applyName;

    @Comment("事由类型")
    @Column()
    private String reasonType;

    @Comment("事由号")
    @Column()
    private Long reasonId;

    @Comment("事由")
    @Column()
    private String reasonName;

    @Comment("顾问姓名")
    @Column()
    private String consultantName;

    @Comment("复合能力id")
    @Column()
    private Long capasetLevelId;

    @Comment("复合能力")
    @Column()
    private String capasetLevelName;

    @Comment("预计入场日期")
    @Column()
    private LocalDate expectedStartDate;

    @Comment("预计结束日期")
    @Column()
    private LocalDate expectedEndDate;

    @Comment("结算类型（人天/任务/月）")
    @Column()
    private String settleType;

    @Comment("服务费(元/人天、月)")
    @Column()
    private String serviceFee;

    @Comment("是否含税")
    @Column()
    private Boolean isTax;

    @Comment("资源引入情况说明")
    @Column(columnDefinition = "LONGTEXT")
    private String situationDescribe;

    @Comment("独立顾问个人信息")
    @Column(length = 500)
    private String personalInfo;

    @Comment("被推荐人简历")
    @Column()
    private String resumeCodes;

    @Comment("派工单上传")
    @Column()
    private String orderCodes;

    @Comment("派工单编号")
    @Column()
    private String applyNo;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

}
