package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.my.query.OvertimeApplicationQuery;
import com.elitesland.tw.tw5.server.prd.my.service.OvertimeApplicationServiceImpl;
import com.elitesland.tw.tw5.server.prd.my.vo.OvertimeApplicationVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * 加班、调休
 *
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/overtimeApplication")
@Slf4j
public class OvertimeApplicationController {

    @Autowired
    private OvertimeApplicationServiceImpl OvertimeApplicationService;

    /**
     * 加班申请
     *
     * @param overtimeApplicationVO
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/submitOvertime")
    public TwOutputUtil submitOvertime(@RequestBody OvertimeApplicationVO overtimeApplicationVO) {
        if(overtimeApplicationVO.getProjectId() == null){
            return TwOutputUtil.error("500","项目id不能为空",null);
        }
        if(LocalDate.now().isAfter(overtimeApplicationVO.getOvertimeWorkDate())){
            return TwOutputUtil.error("500","工作计划不能早于今天",null);
        }

        Long overtimeId = OvertimeApplicationService.submitOvertime(overtimeApplicationVO);

        return TwOutputUtil.ok(overtimeId);
    }

    /**
     * @description: 通过加班id获取工作流的id
     * @author: dragonHuang
     * @date: 2023/9/5 10:59
     * @param: id 加班表id
     * @return: TwOutputUtil
     **/

    @GetMapping("/findOvertimeApplicationById")
    public TwOutputUtil findOvertimeApplicationById(@RequestParam Long id){
        OvertimeApplicationVO overtimeApplicationVO = OvertimeApplicationService.findOvertimeApplicationById(id);

        return TwOutputUtil.ok(overtimeApplicationVO);
    }

    /**
     * @description: 通过当前登录人去查询可用加班的数据
     * @author: dragonHuang
     * @date: 2023/9/5 10:59
     * @return: TwOutputUtil
     **/
    @GetMapping("/findAvailableOvertimeApplications")
    public TwOutputUtil findAvailableOvertimeApplications(){
        List<OvertimeApplicationVO> overtimeApplicationVO = OvertimeApplicationService.findAvailableOvertimeApplications();

        return TwOutputUtil.ok(overtimeApplicationVO);
    }

    /**
     * @description: 查询加班列表带分页
     * @author: dragonHuang
     * @date: 2023/9/5 10:59
     * @return: TwOutputUtil
     **/
    @GetMapping("/findOvertimeApplicationPage")
    public TwOutputUtil findOvertimeApplicationPage(OvertimeApplicationQuery query){
        PagingVO<OvertimeApplicationVO> overtimeApplicationPage = OvertimeApplicationService.findOvertimeApplicationPage(query);

        return TwOutputUtil.ok(overtimeApplicationPage);
    }
}
