package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.UserRecentVacationApplyVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QUserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QUserVacationApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationApplyDetailRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Repository
@RequiredArgsConstructor
public class UserVacationApplyDetailDAO {

    private final UserVacationApplyDetailRepo repo;

    private final JPAQueryFactory jpaQueryFactory;

    private final QUserVacationApplyDO userVacationApplyDO = QUserVacationApplyDO.userVacationApplyDO;

    private final QUserVacationApplyDetailDO userVacationApplyDetailDO = QUserVacationApplyDetailDO.userVacationApplyDetailDO;

    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;

    private final QPrdOrgEmployeeDO employeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;


    public List<UserVacationApplyDetailDO> saveAll(List<UserVacationApplyDetailDO> list) {
        return repo.saveAll(list);
    }

    public void updateProcStatus(UserVacationApplyDetailDO detailDO) {
        JPAUpdateClause update = jpaQueryFactory.update(userVacationApplyDetailDO)
                .where(userVacationApplyDetailDO.id.eq(detailDO.getId()));

        if (detailDO.getProcInstId() != null) {
            update.set(userVacationApplyDetailDO.procInstId, detailDO.getProcInstId());
        }
        if (detailDO.getProcInstStatus() != null) {
            update.set(userVacationApplyDetailDO.procInstStatus, detailDO.getProcInstStatus());
        }
        if (detailDO.getApprovedTime() != null) {
            update.set(userVacationApplyDetailDO.approvedTime, detailDO.getApprovedTime());
        }
        // 执行修改
        update.execute();
    }

    public void updateProcStatusByApplyId(Long applyId, ProcInstStatus procInstStatus) {
        JPAUpdateClause update = jpaQueryFactory.update(userVacationApplyDetailDO)
                .where(userVacationApplyDetailDO.applyId.eq(applyId));
        if (procInstStatus != null) {
            update.set(userVacationApplyDetailDO.procInstStatus, procInstStatus);
        }

        // 执行修改
        update.execute();
    }

    public List<UserVacationApplyDetailDO> findByProcIdAndExtFlag(String procId, Boolean flag) {
        return repo.findByProcInstIdAndExtVacationFlag(procId, flag);
    }

    public List<UserVacationApplyDetailDO> findByApplyIdAndExtFlag(Long applyId, Boolean flag) {
        return repo.findByApplyIdAndExtVacationFlag(applyId, flag);
    }

    public List<UserVacationApplyDetailDO> findByApplyId(Long applyId) {
        return repo.findByApplyId(applyId);
    }

    private JPAQuery<UserVacationApplyVO> getJpaQueryWhere(UserVacationApplyQuery query) {
        JPAQuery<UserVacationApplyVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getIds())) {
            jpaQuery.where(userVacationApplyDetailDO.id.in(query.getIds()));
        }
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            jpaQuery.where(userVacationApplyDO.applyNo.eq(query.getApplyNo()));
        }
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            jpaQuery.where(userVacationApplyDO.userId.eq(query.getUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdoRef.orgId.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getParentUserId())) {
            jpaQuery.where(qdoRef.parentId.eq(query.getParentUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getVacationType())) {
            jpaQuery.where(userVacationApplyDO.vacationType.eq(query.getVacationType()));
        }
        if (!ObjectUtils.isEmpty(query.getVacationId())) {
            jpaQuery.where(userVacationApplyDO.vacationId.eq(query.getVacationId()));
        }
        if (StringUtils.hasLength(query.getVdateStart()) && StringUtils.hasLength(query.getVdateEnd())) {
            jpaQuery.where(userVacationApplyDetailDO.vDate.between(TimeUtil.dateFromYmd(query.getVdateStart()), TimeUtil.dateFromYmd(query.getVdateEnd())));
        }
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            jpaQuery.where(userVacationApplyDO.procInstStatus.eq(ProcInstStatus.valueOf(query.getApprStatus())));
        }

        if (!ObjectUtils.isEmpty(query.getApprDateStr())) {
            LocalDate dateStart = LocalDate.parse(query.getApprDateStr().get(0));
            LocalDateTime timeStart = dateStart.atStartOfDay();
            LocalDate dateEnd = LocalDate.parse(query.getApprDateStr().get(1));
            LocalDateTime timeEnd = dateEnd.plusDays(1).atStartOfDay();
            jpaQuery.where(userVacationApplyDO.createTime.between(timeStart, timeEnd));
        }
        // jpaQuery.orderBy(userVacationApplyDO.applyNo.desc(), userVacationApplyDetailDO.vDate.desc());
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, userVacationApplyDO._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(userVacationApplyDetailDO, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<UserVacationApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(UserVacationApplyVO.class,
                        userVacationApplyDetailDO.id,
                        userVacationApplyDetailDO.applyId,
                        userVacationApplyDO.applyNo,
                        userVacationApplyDO.userId,
                        userVacationApplyDO.procInstId,
                        userVacationApplyDetailDO.vDate.as("detailVDate"),
                        userVacationApplyDetailDO.vDays.as("vacationDays"),
                        userVacationApplyDetailDO.vInterval.as("detailInterval"),
                        userVacationApplyDO.vacationType,
                        userVacationApplyDO.procInstStatus.as("apprStatus"),
                        userVacationApplyDO.userId.as("apprUserId"),
                        userVacationApplyDO.createTime.as("apprDate"),
                        qdoRef.orgId,
                        qdoRef.parentId.as("parentUserId"),
                        employeeDO.employeeNo
                )).from(userVacationApplyDetailDO)
                .where(userVacationApplyDetailDO.deleteFlag.eq(0))
                .leftJoin(userVacationApplyDO).on(userVacationApplyDetailDO.applyId.eq(userVacationApplyDO.id))
                .leftJoin(qdoRef).on(userVacationApplyDO.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()).and(qdoOrg.isCopy.eq(0)))
                .leftJoin(employeeDO).on(employeeDO.userId.eq(userVacationApplyDO.userId))
                .where(userVacationApplyDO.deleteFlag.eq(0));
    }

    public PagingVO<UserVacationApplyVO> page(UserVacationApplyQuery query) {
        JPAQuery<UserVacationApplyVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<UserVacationApplyVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<UserVacationApplyVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<UserVacationApplyVO> list(UserVacationApplyQuery query) {
        JPAQuery<UserVacationApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<UserVacationApplyVO> result = jpaQuery.fetch();
        return result;
    }

    public List<UserRecentVacationApplyVO> getRecentVacation(UserVacationApplyQuery query) {
        return jpaQueryFactory.select(Projections.bean(UserRecentVacationApplyVO.class,
                        userVacationApplyDO.applyNo,
                        userVacationApplyDO.userId,
                        userVacationApplyDetailDO.vDate.as("detailVDate"),
                        userVacationApplyDetailDO.vDays.as("vacationDays"),
                        userVacationApplyDO.vacationType,
                        userVacationApplyDO.reason
                )).from(userVacationApplyDetailDO)
                .where(userVacationApplyDetailDO.deleteFlag.eq(0))
                .leftJoin(userVacationApplyDO).on(userVacationApplyDetailDO.applyId.eq(userVacationApplyDO.id))
                .where(userVacationApplyDO.userId.eq(query.getUserId()))
                .where(userVacationApplyDetailDO.vDate.goe(TimeUtil.dateFromYmd(query.getVdateStart())))
                .where(userVacationApplyDO.procInstStatus.eq(ProcInstStatus.APPROVED))
                .where(userVacationApplyDO.deleteFlag.eq(0))
                .fetch();
    }

    public List<UserRecentVacationApplyVO> queryByDateAndResId(LocalDate startDate, LocalDate endDate, Long resId, List<ProcInstStatus> procInstStatusList) {
        return jpaQueryFactory.select(Projections.bean(UserRecentVacationApplyVO.class,
                        userVacationApplyDetailDO.vDate.as("detailVDate"),
                        userVacationApplyDetailDO.vDays.as("vacationDays"),
                        userVacationApplyDetailDO.vInterval,
                        userVacationApplyDO.vacationType))
                .from(userVacationApplyDetailDO)
                .leftJoin(userVacationApplyDO).on(userVacationApplyDO.id.eq(userVacationApplyDetailDO.applyId))
                .where(userVacationApplyDetailDO.deleteFlag.eq(0))
                .where(userVacationApplyDO.deleteFlag.eq(0))
                .where(userVacationApplyDetailDO.vDate.between(startDate, endDate))
                .where(userVacationApplyDO.userId.eq(resId))
                .where(userVacationApplyDO.procInstStatus.in(procInstStatusList))
                .fetch();
    }

    @Transactional
    public void deleteAllByApplyId(Long applyId) {
        repo.deleteAllByApplyId(applyId);
    }


}
