package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name = "t_attendance_remark")
@org.hibernate.annotations.Table(appliesTo = "t_attendance_remark", comment = "打卡结果补充")
@Data
@Where(clause = "delete_flag= 0")
public class TAttendanceRemarkDO extends BaseModel {

    @Comment("打卡人员")
    @Column()
    private Long attendanceResId;

    @Comment("打卡ID")
    @Column()
    private Long tAttendanceNormalId;

    @Comment("打卡日期")
    @Column()
    private String attendanceDate;

    @Comment("打卡异常说明")
    @Column()
    private String attendanceAbnormalDesc;

    @Comment("申请时间")
    @Column()
    private LocalDateTime applyDatetime;

    @Comment("审批人员")
    @Column()
    private Long reportToResId;

    @Comment("审批结果")
    @Column()
    private String approvalResult;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvalDatetime;

    @Comment("审批拒绝原因")
    @Column()
    private String rejectedCause;


    @Comment("4.0主键id")
    @Column(name = "attendance_remark_id_v4")
    private Long attendanceRemarkIdV4;

    public void copy(TAttendanceRemarkDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
