package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 资金划款
 *
 * @author wangluyu
 * @date 2024-02-27
 */
@Entity
@Table(name = "t_money_transfer", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_money_transfer", comment = "资金划款")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TMoneyTransferDO extends BaseModel implements Serializable {
    /**
     * 编号
     */
    @Comment("编号")
    @Column()
    private String transferNo;
    /**
     * 申请人
     */
    @Comment("申请人")
    @Column()
    private Long applicantUserId;
    /**
     * 申请日期
     */
    @Comment("申请日期")
    @Column()
    private LocalDate applicantTime;
    /**
     * 申请人所属bu
     */
    @Comment("申请人所属bu")
    @Column()
    private Long applicantBuId;
    /**
     * 划款公司
     */
    @Comment("划款公司")
    @Column()
    private String transferCompany;
    /**
     * 划款公司bookid
     */
    @Comment("划款公司bookid")
    @Column()
    private Long transferCompanyBookId;
    /**
     * 划款账号
     */
    @Comment("划款账号")
    @Column()
    private String transferAccount;
    /**
     * 收款公司
     */
    @Comment("收款公司")
    @Column()
    private String collectionCompany;
    /**
     * 收款公司bookid
     */
    @Comment("收款公司bookid")
    @Column()
    private Long collectionCompanyBookId;
    /**
     * 收款账号
     */
    @Comment("收款账号")
    @Column()
    private String collectionAccount;
    /**
     * 划款金额
     */
    @Comment("划款金额")
    @Column()
    private BigDecimal transferMoney;
    /**
     * 支付方式
     */
    @Comment("支付方式")
    @Column()
    private String payWay;
    /**
     * 划款说明
     */
    @Comment("划款说明")
    @Column()
    private String transferNote;
    /**
     * 划款状态 udc[ADMINISTRATION:COST:ACC_TRANSFER_STATUS]
     */
    @Comment("划款状态 udc[ADMINISTRATION:COST:ACC_TRANSFER_STATUS]")
    @Column()
    private String transferStatus;
    /**
     * 附件
     */
    @Comment("附件")
    @Column()
    private String fileCodes;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 流程审批状态
     */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;


    /**
     *  支付时间
     */
    @Comment("支付时间")
    @Column()
    private LocalDateTime payTime;

    /**
     * 支付状态：S 成功、F 失败、C撤销、D 过期、R 否决 G退票
     */
    @Comment("支付状态：S 成功、F 失败、C撤销、D 过期、R 否决 G退票")
    @Column()
    private String payStatus;

    /**
     * 支付方式：1.网银支付 2.手动支付
     */
    @Comment("支付方式：1.网银支付 2.手动支付")
    @Column()
    private Integer payMode;


    /** 网银提交标识 1.已提交 2.未提交 */
    @Comment("网银提交标识 1.已提交 2.未提交")
    @Column()
    private Integer bankFlag;


    /** 网银失败原因 */
    @Comment("网银失败原因")
    @Column()
    private String bankErrmsg;

    /** 网银提交时间 */
    @Comment("网银提交时间")
    @Column()
    private LocalDateTime bankTime;


    /**
     * 支付用途
     */
    @Comment("支付用途")
    @Column()
    private String payPurpose;


    /**
     * 内部往来凭证
     */
    @Comment("内部往来凭证")
    @Column()
    private String jdeDocNo;

    /**
     * 内部往来凭证2
     */
    @Comment("内部往来凭证2")
    @Column()
    private String jdeDocNo2;

    /**
     * JDE凭证状态(成功、失败)
     */
    @Comment("JDE凭证状态(成功、失败)")
    @Column()
    private String jdeDocState;


    /**
     * 摘要
     */
    @Comment("摘要")
    @Column()
    private String jdeSummary;


    /**
     * 凭证日期
     */
    @Comment("凭证日期")
    @Column()
    private String jdeDocTime;

    /**
     * 内部往来凭证失败原因
     */
    @Comment("内部往来凭证失败原因")
    @Column()
    private String jdeErrMsg;


    public void copy(TMoneyTransferDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }




}
