package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitesland.tw.tw5.server.prd.my.repo.AbnormalWorkApplyDetailRepo;
import com.elitesland.tw.tw5.server.prd.my.dao.AbnormalWorkApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.my.convert.AbnormalWorkApplyDetailConvert;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyDetailService;
import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyDetailPayload;
import com.elitesland.tw.tw5.server.prd.my.entity.AbnormalWorkApplyDetailDO;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyDetailQuery;
import com.elitesland.tw.tw5.server.prd.my.convert.AbnormalWorkApplyDetailConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 远程办公申请明细
 *
 * @author wangly
 * @date 2024-06-12
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AbnormalWorkApplyDetailServiceImpl extends BaseServiceImpl implements AbnormalWorkApplyDetailService {

    private final AbnormalWorkApplyDetailRepo abnormalWorkApplyDetailRepo;
    private final AbnormalWorkApplyDetailDAO abnormalWorkApplyDetailDAO;

    @Override
    public PagingVO<AbnormalWorkApplyDetailVO> queryPaging(AbnormalWorkApplyDetailQuery query){
        return abnormalWorkApplyDetailDAO.queryPaging(query);
    }

    @Override
    public List<AbnormalWorkApplyDetailVO> queryListDynamic(AbnormalWorkApplyDetailQuery query){
        return abnormalWorkApplyDetailDAO.queryListDynamic(query);
    }

    @Override
    public AbnormalWorkApplyDetailVO queryByKey(Long key) {
        AbnormalWorkApplyDetailDO entity = abnormalWorkApplyDetailRepo.findById(key).orElseGet(AbnormalWorkApplyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AbnormalWorkApplyDetailVO vo = AbnormalWorkApplyDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AbnormalWorkApplyDetailVO insert(AbnormalWorkApplyDetailPayload payload) {
        AbnormalWorkApplyDetailDO entityDo = AbnormalWorkApplyDetailConvert.INSTANCE.toDo(payload);
        return AbnormalWorkApplyDetailConvert.INSTANCE.toVo(abnormalWorkApplyDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AbnormalWorkApplyDetailVO update(AbnormalWorkApplyDetailPayload payload) {
        AbnormalWorkApplyDetailDO entity = abnormalWorkApplyDetailRepo.findById(payload.getId()).orElseGet(AbnormalWorkApplyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AbnormalWorkApplyDetailDO entityDo = AbnormalWorkApplyDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AbnormalWorkApplyDetailConvert.INSTANCE.toVo(abnormalWorkApplyDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AbnormalWorkApplyDetailPayload payload) {
        AbnormalWorkApplyDetailDO entity = abnormalWorkApplyDetailRepo.findById(payload.getId()).orElseGet(AbnormalWorkApplyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = abnormalWorkApplyDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            abnormalWorkApplyDetailDAO.deleteSoft(keys);
        }
    }
}
