package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.PrdOrgEmployeeConfigPayload;
import com.elitesland.tw.tw5.api.prd.my.query.PrdOrgEmployeeConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdOrgEmployeeConfigService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdOrgEmployeeConfigVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemShortcutQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemShortcutService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutJsonVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.PrdOrgEmployeeConfigTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.PrdOrgEmployeeConfigConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdOrgEmployeeConfigDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdOrgEmployeeConfigDO;
import com.elitesland.tw.tw5.server.prd.my.repo.PrdOrgEmployeeConfigRepo;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdSystemShortcutIconTypeEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 员工-个人配置
 *
 * @author wangly
 * @date 2024-03-27
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdOrgEmployeeConfigServiceImpl extends BaseServiceImpl implements PrdOrgEmployeeConfigService {

    private final PrdOrgEmployeeConfigRepo prdOrgEmployeeConfigRepo;
    private final PrdOrgEmployeeConfigDAO prdOrgEmployeeConfigDAO;
    private final CacheUtil cacheUtil;
    private final PrdSystemShortcutService prdSystemShortcutService;
    private final String SHORTCUT_PREFIX = "/cloudt/system/com/file/v1/";
    private final String SHORTCUT_SUFFIX = "/show";

    @Override
    public PagingVO<PrdOrgEmployeeConfigVO> queryPaging(PrdOrgEmployeeConfigQuery query) {
        return prdOrgEmployeeConfigDAO.queryPaging(query);
    }

    @Override
    public List<PrdOrgEmployeeConfigVO> queryListDynamic(PrdOrgEmployeeConfigQuery query) {
        List<PrdOrgEmployeeConfigVO> prdOrgEmployeeConfigVOS = prdOrgEmployeeConfigDAO.queryListDynamic(query);
        if (PrdOrgEmployeeConfigTypeEnum.icon.getCode().equals(query.getConfigType())) {
            Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.FINANCE_MEMBER.getCode(),
                    RoleEnum.BUSINESS_PARTNER_MANAGER.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));
            if (!CollectionUtils.isEmpty(prdOrgEmployeeConfigVOS)) {
                PrdSystemShortcutQuery prdSystemShortcutQuery = new PrdSystemShortcutQuery();
                prdSystemShortcutQuery.setShortcutStatus(1);
                List<PrdSystemShortcutVO> prdSystemShortcutVOS = prdSystemShortcutService.queryListDynamic(prdSystemShortcutQuery);
                //
                prdOrgEmployeeConfigVOS.stream().filter(vo ->PrdOrgEmployeeConfigTypeEnum.icon.getCode().equals(vo.getConfigType()) && StringUtils.hasText(vo.getContentJson())).forEach(vo -> {
                    // 将个人图标的json转为list
                    List<PrdSystemShortcutJsonVO> prdSystemShortcutJsonVOS = JSON.parseArray(vo.getContentJson(), PrdSystemShortcutJsonVO.class);
                    // 过滤掉设置
                    prdSystemShortcutJsonVOS = prdSystemShortcutJsonVOS.stream().filter(item -> !item.getType().equals(PrdSystemShortcutIconTypeEnum.SETTING.getCode())).collect(Collectors.toList());
                    if (!rolePermission) {
                        // 没有权限过滤掉业务伙伴
                        prdSystemShortcutJsonVOS = prdSystemShortcutJsonVOS.stream().filter(item -> !item.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode())).collect(Collectors.toList());
                    }
                    PrdSystemShortcutVO moreFunctionShortcutVO = prdSystemShortcutVOS.stream().filter(item -> item.getType().equals(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode())).findFirst().orElse(null);
                    // 过滤后的全部图标
                    List<PrdSystemShortcutVO> newShortcutVO = null;
                    if (rolePermission) {
                        newShortcutVO = prdSystemShortcutVOS.stream().filter(item -> !item.getType().equals(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode())).collect(Collectors.toList());
                    } else {
                        newShortcutVO = prdSystemShortcutVOS.stream().filter(item -> !item.getType().equals(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode()) && !item.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode())).collect(Collectors.toList());
                    }
                    int index = newShortcutVO.size();
                    // 将个人配置图标按名称转为map
                    Map<String, List<PrdSystemShortcutJsonVO>> iconMap = prdSystemShortcutJsonVOS.stream().collect(Collectors.groupingBy(PrdSystemShortcutJsonVO::getType));
                    for (int i = 0; i < index; i++) {
                        // 判断个人配置有没有 没有的话就直接放到最后
                        if (!iconMap.containsKey(newShortcutVO.get(i).getType())) {
                            PrdSystemShortcutVO vo1 = newShortcutVO.get(i);
                            PrdSystemShortcutJsonVO functionVO = new PrdSystemShortcutJsonVO();
                            functionVO.setType(vo1.getType());
                            functionVO.setFixFlag(vo1.getFixFlag());
                            functionVO.setIcon(SHORTCUT_PREFIX + vo1.getShortcutIcon() + SHORTCUT_SUFFIX);
                            functionVO.setTitle(vo1.getShortcutName());
                            functionVO.setBadge("");
                            functionVO.setShowBadgeFlag(false);
                            functionVO.setExt1("");
                            functionVO.setExt2("");
                            functionVO.setExt3("");
                            prdSystemShortcutJsonVOS.add(functionVO);
                        }
                    }
                    // 因为配置中的图标有些可能删除了 但是还在查询的配置中 所以再循环一遍返回的图标 把不存在的图标删除
                    Map<String, List<PrdSystemShortcutVO>> newShortcutVOMap = newShortcutVO.stream().collect(Collectors.groupingBy(PrdSystemShortcutVO::getType));
                    List<PrdSystemShortcutJsonVO> deleteList = new ArrayList<>();
                    prdSystemShortcutJsonVOS.stream().forEach(item -> {
                        if (!newShortcutVOMap.containsKey(item.getType())) {
                            deleteList.add(item);
                        }
                    });
                    if(!CollectionUtils.isEmpty(deleteList)){
                        prdSystemShortcutJsonVOS.removeAll(deleteList);
                    }
                    // 因为更多功能的图标位置会按下标来处理 因此如果更多功能没有被删除的话 将他插入到他下标的位置
                    if(moreFunctionShortcutVO!=null && newShortcutVOMap.containsKey(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode())){
                        PrdSystemShortcutJsonVO moreFunctionVO = new PrdSystemShortcutJsonVO();
                        moreFunctionVO.setType(moreFunctionShortcutVO.getType());
                        moreFunctionVO.setFixFlag(moreFunctionShortcutVO.getFixFlag());
                        moreFunctionVO.setIcon(SHORTCUT_PREFIX + moreFunctionShortcutVO.getShortcutIcon() + SHORTCUT_SUFFIX);
                        moreFunctionVO.setTitle(moreFunctionShortcutVO.getShortcutName());
                        moreFunctionVO.setBadge("");
                        moreFunctionVO.setShowBadgeFlag(false);
                        moreFunctionVO.setExt1("");
                        moreFunctionVO.setExt2("");
                        moreFunctionVO.setExt3("");
                        prdSystemShortcutJsonVOS.add(moreFunctionShortcutVO.getSortIndex() - 1, moreFunctionVO);
                    }
                    vo.setContentJson(JSON.toJSONString(prdSystemShortcutJsonVOS));
                });
            }
            return prdOrgEmployeeConfigVOS;
        } else {
            return prdOrgEmployeeConfigVOS;

        }
    }

    @Override
    public PrdOrgEmployeeConfigVO queryByKey(Long key) {
        PrdOrgEmployeeConfigDO entity = prdOrgEmployeeConfigRepo.findById(key).orElseGet(PrdOrgEmployeeConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdOrgEmployeeConfigVO vo = PrdOrgEmployeeConfigConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdOrgEmployeeConfigVO insert(PrdOrgEmployeeConfigPayload payload) {
        PrdOrgEmployeeConfigDO entityDo = PrdOrgEmployeeConfigConvert.INSTANCE.toDo(payload);
        return PrdOrgEmployeeConfigConvert.INSTANCE.toVo(prdOrgEmployeeConfigRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdOrgEmployeeConfigVO update(PrdOrgEmployeeConfigPayload payload) {
        PrdOrgEmployeeConfigDO entity = prdOrgEmployeeConfigRepo.findById(payload.getId()).orElseGet(PrdOrgEmployeeConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdOrgEmployeeConfigDO entityDo = PrdOrgEmployeeConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdOrgEmployeeConfigConvert.INSTANCE.toVo(prdOrgEmployeeConfigRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PrdOrgEmployeeConfigPayload payload) {
        PrdOrgEmployeeConfigDO entity = prdOrgEmployeeConfigRepo.findById(payload.getId()).orElseGet(PrdOrgEmployeeConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = prdOrgEmployeeConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdOrgEmployeeConfigDAO.deleteSoft(keys);
        }
    }

}
