package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.my.payload.TBusiCardApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusiCardApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TBusiCardApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiCardApplyVO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TBusiCardApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TBusiCardApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TBusiCardApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TBusiCardApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * 名片申请
 *
 * @author lemon
 * @date 2023-09-11
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TBusiCardApplyServiceImpl extends BaseServiceImpl implements TBusiCardApplyService {

    private final TBusiCardApplyRepo tBusiCardApplyRepo;
    private final TBusiCardApplyDAO tBusiCardApplyDAO;

    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    private final CacheUtil cacheUtil;

    private final PrdOrgOrganizationDAO daoOrg;

    private final WorkflowUtil workflowUtil;

    private final TransactionUtilService transactionUtilService;

    @Override
    public PagingVO<TBusiCardApplyVO> queryPaging(TBusiCardApplyQuery query) {
        return tBusiCardApplyDAO.queryPaging(query);
    }

    @Override
    public List<TBusiCardApplyVO> queryListDynamic(TBusiCardApplyQuery query) {
        return tBusiCardApplyDAO.queryListDynamic(query);
    }

    @Override
    public TBusiCardApplyVO queryByKey(Long key) {
        TBusiCardApplyVO vo = tBusiCardApplyDAO.queryByKey(key);
        vo.setOuName(cacheUtil.getCompanyNameByBookId(vo.getOuId()));
        //        { label: '邮寄到公司', value: 'COMPANY' },
//        { label: '邮寄到指定地点', value: 'SPECIFIED_ADDR' },
        String mailFlagDesc = "邮寄到公司";
        if (StringUtils.hasText(vo.getMailFlag()) && vo.getMailFlag().equals("SPECIFIED_ADDR")) {
            mailFlagDesc = "邮寄到指定地点";
        }
        vo.setMailFlagDesc(mailFlagDesc);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TBusiCardApplyVO insert(TBusiCardApplyPayload payload) {
        // 这么做的原因是cTitle，eTitle,eName,前端传值一直获取不到，但是需要保证4.0、5.0字段一直，只能这样
        payload.setETitle(payload.getEnglishTitle());
        payload.setCTitle(payload.getChineseTitle());
        payload.setEName(payload.getEnglishName());
        TBusiCardApplyDO entityDo = TBusiCardApplyConvert.INSTANCE.toDo(payload);
        TBusiCardApplyDO save = tBusiCardApplyRepo.save(entityDo);
        busiCardApplyProc(save);
        return TBusiCardApplyConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TBusiCardApplyVO update(TBusiCardApplyPayload payload) {
        TBusiCardApplyDO entity = tBusiCardApplyRepo.findById(payload.getId()).orElseGet(TBusiCardApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TBusiCardApplyDO entityDo = TBusiCardApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TBusiCardApplyConvert.INSTANCE.toVo(tBusiCardApplyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TBusiCardApplyPayload payload) {
        TBusiCardApplyDO entity = tBusiCardApplyRepo.findById(payload.getId()).orElseGet(TBusiCardApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tBusiCardApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tBusiCardApplyDAO.deleteSoft(keys);
        }
    }

    /**
     * 名片申请流程
     *
     * @param cardApplyDO
     */
    private void busiCardApplyProc(TBusiCardApplyDO cardApplyDO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.CREATE_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();

            //获取申请人
            Long applyResId = cardApplyDO.getApplyResId();
            String applyResName = cacheUtil.getUserName(applyResId);
            // 申请人部门负责人
            Long basebuId = cardApplyDO.getBasebuId();
            Long baseBuManageId = daoOrg.queryManageIdById(basebuId);
            variables.put("Activity_0x1w1sy", baseBuManageId);
            // 申请人确认
            variables.put("Activity_0un5zq5", applyResId);

            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.BUSI_CARD_APPLY.name(),
                    applyResName + "-名片申请流程",
                    cardApplyDO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        TBusiCardApplyPayload payload = new TBusiCardApplyPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(cardApplyDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            tBusiCardApplyDAO.updateByKeyDynamic(payload);
        });
    }

}
