package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Entity
@Table(name = "prd_org_person")
@org.hibernate.annotations.Table(appliesTo = "prd_org_person", comment = "自然人表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgPersonDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Comment("用户账号")
    @Column()
    private String userName;

//    @Comment("用户名称")
//    @Column()
//    private String firstName;

    @Comment("手机号")
    @Column()
    private String mobile;

    @Comment("是否启用")
    @Column()
    private Boolean enabled;

    @Comment(value = "用户邮箱地址")
    @Column()
    private String email;

    @Comment("姓名")
    @Column()
    private String personName;

    @Comment("外文名")
    @Column()
    private String foreignName;

    @Comment("证件类型")
    @Column()
    private String idType;


    @Comment("证件号码")
    @Column()
    private String idNo;

    @Comment("证件开始日")
    @Column()
    private LocalDate idValidFrom;

    @Comment("证件到期日")
    @Column()
    private LocalDate idValidTo;

    @Comment("证件url")
    @Column()
    private String idValidCodes;

    @Comment("头像url")
    @Column()
    private String headCodes;

    @Comment("生日")
    @Column()
    private LocalDate birthday;

    @Comment("性别")
    @Column()
    private String sex;

    @Comment("国籍")
    @Column()
    private String nationality;

    @Comment("籍贯")
    @Column()
    private String birthplace;

    @Comment("民族")
    @Column()
    private String nation;

    @Comment("婚姻状况")
    @Column()
    private Integer marital;

    @Comment("通讯地址")
    @Column()
    private String addr;

    @Comment("紧急联系人")
    @Column()
    private String urgency_name;

    @Comment("手机号")
    @Column()
    private String urgency_mobile;

    @Comment("关系")
    @Column()
    private String urgency_ref;

    @Comment("排序")
    @Column()
    private Integer sortIndex;

    @Comment("审批状态")
    @Column()
    private String apprStatus;

    @Comment("自我评价")
    @Column()
    private String selfEvaluation;

    @Comment("标签")
    @Column()
    private String selfTagging;

    @Comment("专业技能&专业领域")
    @Column()
    private String professionalSkills;

    @Comment("从业年限")
    @Column()
    private String professionalYears;

    @Comment("个人简历url")
    @Column()
    private String resumeCodes;

    @Comment("自我介绍视频url")
    @Column()
    private String selfIntroVideoCodes;

//    private String extString1;
//    private String extString2;
//    private String extString3;
//    private String extString4;
//    private String extString5;
//    private String extString6;
//    private String extString7;
//    private String extString8;
//    private String extString9;
//    private String extString10;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("是否黑名单")
    @Column()
    private Boolean inBlackList;

    @Comment("平台邮箱")
    @Column()
    private String platformEmail;
}
