package com.elitesland.tw.tw5.server.prd.partner.common.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 公司主体-证件信息
 *
 * @author wangly
 * @date 2023-05-29
 */
@Entity
@Table(name = "com_book_license", indexes = {
        @Index(name="index_book_id",columnList = "book_id")
})
@org.hibernate.annotations.Table(appliesTo = "com_book_license", comment = "公司主体-证件信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BookLicenseDO extends BaseModel implements Serializable  {
    /** 地址薄id */
    @Comment("地址薄id")
    @Column(name = "book_id")
    private Long bookId;
    /** 证件编号 */
    @Comment("证件编号")
    @Column()
    private String licenseNo;
    /** 证件类型 */
    @Comment("证件类型")
    @Column()
    private String licenseType;
    /** 证件状态 udc[CRM:COMPANY:LICENSE_STATUS] */
    @Comment("证件状态 udc[CRM:COMPANY:LICENSE_STATUS]")
    @Column()
    private String licenseStatus;
    /** 失效日期 */
    @Comment("失效日期")
    @Column()
    private LocalDate invalidDate;
    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCode;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 扩展字段1 */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /** 扩展字段2 */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /** 扩展字段3 */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /** 扩展字段4 */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /** 扩展字段5 */
    @Comment("扩展字段5")
    @Column()
    private String ext5;

    public void copy(BookLicenseDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
