package com.elitesland.tw.tw5.server.prd.partner.strategy.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 分级策略
 *
 * @author wangly
 * @date 2023-06-16
 */
@Entity
@Table(name = "business_strategy", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "business_strategy", comment = "分级策略")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessStrategyDO extends BaseModel implements Serializable  {
    /** 策略编号 */
    @Comment("策略编号")
    @Column()
    private String strategyNo;
    /** 分级策略名称 */
    @Comment("分级策略名称")
    @Column()
    private String strategyName;
    /** 分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY] */
    @Comment("分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    @Column()
    private String strategyIdentity;
    /** 策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS] */
    @Comment("策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS]")
    @Column()
    private String strategyStatus;
    /** 策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY] */
    @Comment("策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY]")
    @Column()
    private String strategyPriority;
    /** 策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE] */
    @Comment("策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE]")
    @Column()
    private String strategyRange;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;
    /** 策略范围明细 */
    @Comment("策略范围明细")
    @Column()
    private String strategyRangeDetail;

    public void copy(BusinessStrategyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
