package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyGradeSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyGradeSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyGradeSettingService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyGradeSettingVO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessStrategyGradeSettingConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyGradeSettingDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyGradeSettingDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyGradeSettingRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 分级策略等级配置
 *
 * @author wangly
 * @date 2023-06-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessStrategyGradeSettingServiceImpl extends BaseServiceImpl implements BusinessStrategyGradeSettingService {

    private final BusinessStrategyGradeSettingRepo businessStrategyGradeSettingRepo;
    private final BusinessStrategyGradeSettingDAO businessStrategyGradeSettingDAO;

    @Override
    public PagingVO<BusinessStrategyGradeSettingVO> queryPaging(BusinessStrategyGradeSettingQuery query){
        return businessStrategyGradeSettingDAO.queryPaging(query);
    }

    @Override
    public List<BusinessStrategyGradeSettingVO> queryListDynamic(BusinessStrategyGradeSettingQuery query){
        return businessStrategyGradeSettingDAO.queryListDynamic(query);
    }

    @Override
    public BusinessStrategyGradeSettingVO queryByKey(Long key) {
        BusinessStrategyGradeSettingDO entity = businessStrategyGradeSettingRepo.findById(key).orElseGet(BusinessStrategyGradeSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyGradeSettingVO vo = BusinessStrategyGradeSettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyGradeSettingVO insert(BusinessStrategyGradeSettingPayload payload) {
        BusinessStrategyGradeSettingDO entityDo = BusinessStrategyGradeSettingConvert.INSTANCE.toDo(payload);
        return BusinessStrategyGradeSettingConvert.INSTANCE.toVo(businessStrategyGradeSettingRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyGradeSettingVO update(BusinessStrategyGradeSettingPayload payload) {
        BusinessStrategyGradeSettingDO entity = businessStrategyGradeSettingRepo.findById(payload.getId()).orElseGet(BusinessStrategyGradeSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyGradeSettingDO entityDo = BusinessStrategyGradeSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessStrategyGradeSettingConvert.INSTANCE.toVo(businessStrategyGradeSettingRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessStrategyGradeSettingPayload payload) {
        BusinessStrategyGradeSettingDO entity = businessStrategyGradeSettingRepo.findById(payload.getId()).orElseGet(BusinessStrategyGradeSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessStrategyGradeSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessStrategyGradeSettingDAO.deleteSoft(keys);
        }
    }

    @Override
    public void saveAll(List<BusinessStrategyGradeSettingPayload> payloadList, Long strategyId) {
        List<BusinessStrategyGradeSettingDO> businessStrategyGradeSettingDOList = payloadList.stream().map(payLoad -> {
            BusinessStrategyGradeSettingDO businessStrategyGradeSettingDO = new BusinessStrategyGradeSettingDO();
            BeanUtil.copyProperties(payLoad,businessStrategyGradeSettingDO, CopyOptions.create().setIgnoreNullValue(true));
            businessStrategyGradeSettingDO.setStrategyId(strategyId);
            return businessStrategyGradeSettingDO;
        }).collect(Collectors.toList());
        businessStrategyGradeSettingRepo.saveAll(businessStrategyGradeSettingDOList);
    }

    @Override
    public List<BusinessStrategyGradeSettingVO> queryListByStrategyId(Long strategyId) {
        List<BusinessStrategyGradeSettingDO> businessStrategyGradeSettingDOList = businessStrategyGradeSettingRepo.findByStrategyIdAndDeleteFlag(strategyId, 0);
        List<BusinessStrategyGradeSettingVO> businessStrategyGradeSettingVOList = BusinessStrategyGradeSettingConvert.INSTANCE.toVoList(businessStrategyGradeSettingDOList);
        return businessStrategyGradeSettingVOList;
    }
}
