package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyRefPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyRefQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyRefService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyRefVO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessStrategyRefConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessStrategyRefDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyRefDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyRefRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 分级策略业务伙伴映射关系
 *
 * @author wanlgy
 * @date 2023-06-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessStrategyRefServiceImpl extends BaseServiceImpl implements BusinessStrategyRefService {

    private final BusinessStrategyRefRepo businessStrategyRefRepo;
    private final BusinessStrategyRefDAO businessStrategyRefDAO;

    @Override
    public PagingVO<BusinessStrategyRefVO> queryPaging(BusinessStrategyRefQuery query){
        return businessStrategyRefDAO.queryPaging(query);
    }

    @Override
    public List<BusinessStrategyRefVO> queryListDynamic(BusinessStrategyRefQuery query){
        return businessStrategyRefDAO.queryListDynamic(query);
    }

    @Override
    public BusinessStrategyRefVO queryByKey(Long key) {
        BusinessStrategyRefDO entity = businessStrategyRefRepo.findById(key).orElseGet(BusinessStrategyRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyRefVO vo = BusinessStrategyRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyRefVO insert(BusinessStrategyRefPayload payload) {
        BusinessStrategyRefDO entityDo = BusinessStrategyRefConvert.INSTANCE.toDo(payload);
        return BusinessStrategyRefConvert.INSTANCE.toVo(businessStrategyRefRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessStrategyRefVO update(BusinessStrategyRefPayload payload) {
        BusinessStrategyRefDO entity = businessStrategyRefRepo.findById(payload.getId()).orElseGet(BusinessStrategyRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessStrategyRefDO entityDo = BusinessStrategyRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessStrategyRefConvert.INSTANCE.toVo(businessStrategyRefRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessStrategyRefPayload payload) {
        BusinessStrategyRefDO entity = businessStrategyRefRepo.findById(payload.getId()).orElseGet(BusinessStrategyRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessStrategyRefDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessStrategyRefDAO.deleteSoft(keys);
        }
    }

    @Override
    public void saveAll(List<BusinessStrategyRefPayload> payloadList, Long strategyId) {
        List<BusinessStrategyRefDO> BusinessStrategyRefDOList = payloadList.stream().map(payLoad -> {
            BusinessStrategyRefDO businessStrategyRefDO = new BusinessStrategyRefDO();
            BeanUtil.copyProperties(payLoad,businessStrategyRefDO, CopyOptions.create().setIgnoreNullValue(true));
            businessStrategyRefDO.setStrategyId(strategyId);
            return businessStrategyRefDO;
        }).collect(Collectors.toList());
        businessStrategyRefRepo.saveAll(BusinessStrategyRefDOList);
    }

    @Override
    public List<BusinessStrategyRefVO> queryListByStrategyId(Long strategyId) {
        List<BusinessStrategyRefVO> businessStrategyRefVOList = businessStrategyRefDAO.findByStrategyId(strategyId);
        return businessStrategyRefVOList;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByStrategyId(Long strategyId) {
        businessStrategyRefDAO.deleteSoftByStrategyId(strategyId);
    }

    @Override
    public List<BusinessStrategyCustomerVO> queryAppointCustomerInfoByStrategyId(Long strategyId){
        return businessStrategyRefDAO.queryAppointCustomerInfoByStrategyId(strategyId);
    }

}
