package com.elitesland.tw.tw5.server.prd.pms.common.functionEnum;

import lombok.Getter;

/**
 * @author eason.shi
 * @since 2018/12/20
 */
public interface DistributeEnum {
    enum distStatus implements DistributeEnum {
        BROADCAST_OVERDUE("BROADCAST OVERDUE", "广播过期"),
        BROADCASTING("BROADCASTING", "广播中"),
        CREATE("CREATE", "新建"),
        DISTRIBUTED("DISTRIBUTED", "已派发"),
        DISTRIBUTING("DISTRIBUTING", "派发中"),

        ;
        /**
         * 状态
         */
        @Getter
        private final String code;

        /**
         * 描述
         */
        @Getter
        private final String desc;

        distStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    enum distMethod implements DistributeEnum {
        DESIGNATE("DESIGNATE", "指定派发"),
        BROADCASTING("BROADCAST", "广播派发"),
        ;
        /**
         * 状态
         */
        @Getter
        private final String code;

        /**
         * 描述
         */
        @Getter
        private final String desc;

        distMethod(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    enum distType implements DistributeEnum {

        TASK_PACKAGE("TASK_PACKAGE", "任务包"),
        TASK("TASK", "任务"),

        PROJECT("PROJECT", "项目"),
        ;
        /**
         * 状态
         */
        @Getter
        private final String code;

        /**
         * 描述
         */
        @Getter
        private final String desc;

        distType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }


}
