package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectReportPlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectReportPlanQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectReportPlanService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectReportPlanVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 项目汇报计划管理
 *
 * @author carl
 * @date 2023-09-05
 */
@Api(tags = "项目汇报计划管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectReportPlan")
@Slf4j
public class PmsProjectReportPlanController {

    private final PmsProjectReportPlanService pmsProjectReportPlanService;

    /**
     * 项目汇报计划管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目汇报计划管理-新增")
    public TwOutputUtil<PmsProjectReportPlanVO> insert(@RequestBody PmsProjectReportPlanPayload payload) {
        return TwOutputUtil.ok(pmsProjectReportPlanService.insert(payload));
    }

    /**
     * 项目汇报计划管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("项目汇报计划管理-更新")
    public TwOutputUtil<PmsProjectReportPlanVO> update(@RequestBody PmsProjectReportPlanPayload payload) {
        return TwOutputUtil.ok(pmsProjectReportPlanService.update(payload));
    }

    /**
     * 项目汇报计划管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("项目汇报计划管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsProjectReportPlanPayload payload) {
        return TwOutputUtil.ok(pmsProjectReportPlanService.updateByKeyDynamic(payload));
    }

    /**
     * 项目汇报计划管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("项目汇报计划管理-主键查询")
    public TwOutputUtil<PmsProjectReportPlanVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectReportPlanService.queryByKey(key));
    }

    /**
     * 项目汇报计划管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("项目汇报计划管理-分页")
    public TwOutputUtil<PagingVO<PmsProjectReportPlanVO>> paging(PmsProjectReportPlanQuery query) {
        return TwOutputUtil.ok(pmsProjectReportPlanService.queryPaging(query));
    }

    /**
     * 项目汇报计划管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("项目汇报计划管理-查询列表")
    public TwOutputUtil<List<PmsProjectReportPlanVO>> queryList(PmsProjectReportPlanQuery query) {
        return TwOutputUtil.ok(pmsProjectReportPlanService.queryListDynamic(query));
    }

    /**
     * 项目汇报计划管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("项目汇报计划管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectReportPlanService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

