package com.elitesland.tw.tw5.server.prd.pms.service;


import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributeRespondPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeRespondQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeRespondService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeRespondVO;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.RespondEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsDistributeRespondConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeRespondDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsDistributeRespondDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsDistributeRespondRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 派发响应
 *
 * @author xxb
 * @date 2023-10-08
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsDistributeRespondServiceImpl extends BaseServiceImpl implements PmsDistributeRespondService {

    private final PmsDistributeRespondRepo pmsDistributeRespondRepo;
    private final PmsDistributeRespondDAO pmsDistributeRespondDAO;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void respond(List<PmsDistributeRespondPayload> list, String respStatus) {
        Long respondentResId = GlobalUtil.getLoginUserId();
        LocalDateTime respTime = LocalDateTime.now();

        List<PmsDistributeRespondDO> dos = new ArrayList<>();
        for (PmsDistributeRespondPayload disRespond : list) {
            disRespond.setRespondentResId(respondentResId);//响应人id
            disRespond.setRespStatus(respStatus);//响应状态
            disRespond.setRespTime(respTime);//响应时间
            dos.add(PmsDistributeRespondConvert.INSTANCE.toDo(disRespond));

            // todo 获取消息配置,发送消息
            // twMessageConfigurationService.sendMessageByNo("DIST_RESPOND_SUBMIT", edpCdsNameResolver.resolveCdcNames(disRespond));
        }
        if (!ObjectUtil.isEmpty(dos)) {
            pmsDistributeRespondDAO.saveAll(dos);
        }
    }

    @Override
    public void rejectRespond(List<Long> ids) {
        pmsDistributeRespondDAO.updateStatus(ids, RespondEnum.REJECTED.getCode());
    }

    @Override
    public void batchSave(List<PmsDistributeRespondPayload> respondPayloads, Long disId) {
        PmsDistributeRespondQuery query = new PmsDistributeRespondQuery();
        query.setDistId(disId);
        List<PmsDistributeRespondVO> list = pmsDistributeRespondDAO.queryListDynamic(query);
        List<Long> fromDB = list.stream().map(v -> v.getRespondentResId()).collect(Collectors.toList());

        // 删除
        List<Long> delList = respondPayloads.stream().filter(v -> !fromDB.contains(v.getRespondentResId())).map(v -> v.getId()).collect(Collectors.toList());
        pmsDistributeRespondDAO.deleteSoft(delList);

        //新增或修改
        List<PmsDistributeRespondDO> dos = new ArrayList<>();
        for (PmsDistributeRespondPayload payload : respondPayloads) {
            dos.add(PmsDistributeRespondConvert.INSTANCE.toDo(payload));
        }
        if (!ObjectUtil.isEmpty(dos)) {
            pmsDistributeRespondDAO.saveAll(dos);
        }
    }

    @Override
    public PagingVO<PmsDistributeRespondVO> queryPaging(PmsDistributeRespondQuery query) {
        return pmsDistributeRespondDAO.queryPaging(query);
    }

    @Override
    public List<PmsDistributeRespondVO> queryListDynamic(PmsDistributeRespondQuery query) {
        return pmsDistributeRespondDAO.queryListDynamic(query);
    }

    @Override
    public PmsDistributeRespondVO queryByKey(Long key) {
        PmsDistributeRespondDO entity = pmsDistributeRespondRepo.findById(key).orElseGet(PmsDistributeRespondDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsDistributeRespondVO vo = PmsDistributeRespondConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsDistributeRespondVO insert(PmsDistributeRespondPayload payload) {
        PmsDistributeRespondDO entityDo = PmsDistributeRespondConvert.INSTANCE.toDo(payload);
        return PmsDistributeRespondConvert.INSTANCE.toVo(pmsDistributeRespondRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsDistributeRespondVO update(PmsDistributeRespondPayload payload) {
        PmsDistributeRespondDO entity = pmsDistributeRespondRepo.findById(payload.getId()).orElseGet(PmsDistributeRespondDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsDistributeRespondDO entityDo = PmsDistributeRespondConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsDistributeRespondConvert.INSTANCE.toVo(pmsDistributeRespondRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsDistributeRespondPayload payload) {
        PmsDistributeRespondDO entity = pmsDistributeRespondRepo.findById(payload.getId()).orElseGet(PmsDistributeRespondDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsDistributeRespondDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsDistributeRespondDAO.deleteSoft(keys);
        }
    }

    @Override
    public void deleteByDistIds(List<Long> distIds) {
        if (!distIds.isEmpty()) {
            pmsDistributeRespondDAO.deleteByDistIds(distIds);
        }
    }

}
