package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.BusinessDocTypeRefEnum;
import com.elitesland.tw.tw5.server.common.funConfig.support.AbstractBusinessDocTypeCheckAuthorityService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * pms项目文档配置检查验证服务impl
 *
 * @author duwh
 * @date 2023/12/11
 */
@Slf4j
@Service
public class PmsProjectDocConfigCheckAuthServiceImpl extends AbstractBusinessDocTypeCheckAuthorityService {

    @Resource
    private PmsProjectService pmsProjectService;
    @Resource
    private PrdOrgOrganizationService prdOrgOrganizationService;

    @Resource
    private CacheUtil cacheUtil;

    public PmsProjectDocConfigCheckAuthServiceImpl() {
        super(BusinessDocTypeRefEnum.PMS_PROJECT);
    }


    @Override
    public TwException checkAuthority(Long docId) {
        return null;
    }

    @Override
    public TwException checkAuthority(Long docId, String docType) {
        return null;
    }

    @Override
    public TwException checkAuthority(Long userId, Long orgId, List<String> roleList, Long docId, String docType, Long configId) {
        // PMO部长（梁）、PMO专员 (角色控制 ，在通用文档中校验，此)
        // PM、 项目PMO、交付负责人、交付BU leader（）
        if (null != docId) {
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKeySimple(docId);
            // if (ObjectUtils.isEmpty(pmsProjectVO.getDeliBuId())) {
            //     return TwException.error("", "项目交付负责人不能为空");
            // }
            List<Long> resIds = Lists.newArrayList();
            // 交付BULeader
            Long deliBuLeader = prdOrgOrganizationService.queryManageIdById(pmsProjectVO.getDeliBuId());
            resIds.add(deliBuLeader);
            // 交付负责人
            resIds.add(pmsProjectVO.getDeliUserId());
            // 项目PMO
            resIds.add(pmsProjectVO.getPmoResId());
            // 项目经理PM
            resIds.add(pmsProjectVO.getPmResId());
            if (!resIds.contains(userId)) {
                log.error("用户：{}没有权限访问项目文档（项目经理、交付负责人、交付bu leader、项目PMO、公司PMO才可以操作），请联系管理员！", userId);
                return TwException.error("", "您没有权限（项目经理、交付负责人、交付bu leader、项目PMO、公司PMO才可以操作），请联系管理员！");
            }
        }
        return null;
    }


}
